/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.latex3;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.latex.latex3.ClistCommand;
import com.dickimawbooks.texparserlib.latex.latex3.L3StorageCommand;
import com.dickimawbooks.texparserlib.latex.latex3.SequenceCommand;
import com.dickimawbooks.texparserlib.latex.latex3.TokenListCommand;
import java.io.IOException;

public class AddToL3Object
extends ControlSequence {
    protected boolean global = false;
    protected boolean append = true;
    protected char suffix1 = (char)78;
    protected char suffix2 = (char)110;

    public AddToL3Object(String string) {
        this(string, string.contains("_gput_"), string.contains("_right"), string.charAt(string.length() - 2), string.charAt(string.length() - 1));
    }

    public AddToL3Object(String string, boolean bl, boolean bl2, char c, char c2) {
        super(string);
        this.global = bl;
        this.append = bl2;
        this.suffix1 = c;
        this.suffix2 = c2;
    }

    @Override
    public Object clone() {
        return new AddToL3Object(this.getName(), this.global, this.append, this.suffix1, this.suffix2);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject;
        ControlSequence controlSequence;
        String string;
        if (this.suffix1 == 'c') {
            string = this.popLabelString(teXParser, teXObjectList);
            controlSequence = teXParser.getControlSequence(string);
        } else {
            controlSequence = this.popControlSequence(teXParser, teXObjectList);
            string = controlSequence.getName();
        }
        TeXObject teXObject2 = TeXParserUtils.popL3Arg(teXParser, teXObjectList, this.suffix2);
        if (controlSequence instanceof L3StorageCommand) {
            teXObject = (L3StorageCommand)((Object)controlSequence);
            if (!this.global) {
                teXObject = (L3StorageCommand)controlSequence.clone();
            }
        } else {
            teXObject = this.name.startsWith("seq_") ? new SequenceCommand(string) : (this.name.startsWith("clist_") ? new ClistCommand(string) : new TokenListCommand(string));
        }
        if (this.append) {
            teXObject.append(teXObject2);
        } else {
            teXObject.prepend(teXObject2);
        }
        teXParser.putControlSequence(!this.global, (ControlSequence)teXObject);
    }
}

