/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.store.embedding.filter.Filter;

public class EmbeddingSearchRequest {
    private final Embedding queryEmbedding;
    private final int maxResults;
    private final double minScore;
    private final Filter filter;

    public EmbeddingSearchRequest(Embedding queryEmbedding, Integer maxResults, Double minScore, Filter filter) {
        this.queryEmbedding = ValidationUtils.ensureNotNull(queryEmbedding, "queryEmbedding");
        this.maxResults = ValidationUtils.ensureGreaterThanZero(Utils.getOrDefault(maxResults, 3), "maxResults");
        this.minScore = ValidationUtils.ensureBetween(Utils.getOrDefault(minScore, 0.0), 0.0, 1.0, "minScore");
        this.filter = filter;
    }

    public Embedding queryEmbedding() {
        return this.queryEmbedding;
    }

    public int maxResults() {
        return this.maxResults;
    }

    public double minScore() {
        return this.minScore;
    }

    public Filter filter() {
        return this.filter;
    }

    public static EmbeddingSearchRequestBuilder builder() {
        return new EmbeddingSearchRequestBuilder();
    }

    public String toString() {
        return "EmbeddingSearchRequest(queryEmbedding=" + this.queryEmbedding + ", maxResults=" + this.maxResults + ", minScore=" + this.minScore + ", filter=" + this.filter + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmbeddingSearchRequest)) {
            return false;
        }
        EmbeddingSearchRequest other = (EmbeddingSearchRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.maxResults != other.maxResults) {
            return false;
        }
        if (Double.compare(this.minScore, other.minScore) != 0) {
            return false;
        }
        Embedding this$queryEmbedding = this.queryEmbedding;
        Embedding other$queryEmbedding = other.queryEmbedding;
        if (this$queryEmbedding == null ? other$queryEmbedding != null : !((Object)this$queryEmbedding).equals(other$queryEmbedding)) {
            return false;
        }
        Filter this$filter = this.filter;
        Filter other$filter = other.filter;
        return !(this$filter == null ? other$filter != null : !this$filter.equals(other$filter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EmbeddingSearchRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.maxResults;
        long $minScore = Double.doubleToLongBits(this.minScore);
        result = result * 59 + (int)($minScore >>> 32 ^ $minScore);
        Embedding $queryEmbedding = this.queryEmbedding;
        result = result * 59 + ($queryEmbedding == null ? 43 : ((Object)$queryEmbedding).hashCode());
        Filter $filter = this.filter;
        result = result * 59 + ($filter == null ? 43 : $filter.hashCode());
        return result;
    }

    public static class EmbeddingSearchRequestBuilder {
        private Embedding queryEmbedding;
        private Integer maxResults;
        private Double minScore;
        private Filter filter;

        EmbeddingSearchRequestBuilder() {
        }

        public EmbeddingSearchRequestBuilder queryEmbedding(Embedding queryEmbedding) {
            this.queryEmbedding = queryEmbedding;
            return this;
        }

        public EmbeddingSearchRequestBuilder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public EmbeddingSearchRequestBuilder minScore(Double minScore) {
            this.minScore = minScore;
            return this;
        }

        public EmbeddingSearchRequestBuilder filter(Filter filter) {
            this.filter = filter;
            return this;
        }

        public EmbeddingSearchRequest build() {
            return new EmbeddingSearchRequest(this.queryEmbedding, this.maxResults, this.minScore, this.filter);
        }

        public String toString() {
            return "EmbeddingSearchRequest.EmbeddingSearchRequestBuilder(queryEmbedding=" + this.queryEmbedding + ", maxResults=" + this.maxResults + ", minScore=" + this.minScore + ", filter=" + this.filter + ")";
        }
    }
}

