/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.query;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.ExtendedQueryBase;
import org.apache.solr.search.SolrIndexSearcher;

public class FilterQuery
extends ExtendedQueryBase {
    protected final Query q;

    public FilterQuery(Query q) {
        if (q == null) {
            this.q = new MatchNoDocsQuery();
            return;
        }
        this.q = q;
    }

    @Override
    public final void setCache(boolean cache) {
    }

    @Override
    public final boolean getCache() {
        return false;
    }

    public Query getQuery() {
        return this.q;
    }

    public int hashCode() {
        return this.q.hashCode() + -1058646507;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FilterQuery)) {
            return false;
        }
        FilterQuery fq = (FilterQuery)obj;
        return this.q.equals((Object)fq.q);
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("filter(");
        sb.append(this.q.toString(""));
        sb.append(')');
        return sb.toString();
    }

    public void visit(QueryVisitor visitor) {
        this.q.visit(visitor.getSubVisitor(BooleanClause.Occur.FILTER, (Query)this));
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query newQ = this.q.rewrite(reader);
        if (!newQ.equals((Object)this.q)) {
            return new FilterQuery(newQ);
        }
        return this;
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        if (!(searcher instanceof SolrIndexSearcher)) {
            return new ConstantScoreQuery(this.q).createWeight(searcher, scoreMode, 0.0f);
        }
        SolrIndexSearcher solrSearcher = (SolrIndexSearcher)searcher;
        DocSet docs = solrSearcher.getDocSet(this.q);
        return docs.makeQuery().createWeight(searcher, scoreMode, 0.0f);
    }
}

