# This file has been autogenerated by the pywayland scanner

# Copyright 2016 The Chromium Authors.
# Copyright 2017 Intel Corporation
# Copyright 2018 Collabora, Ltd
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)


class ZwpLinuxBufferReleaseV1(Interface):
    """Buffer release explicit synchronization

    This object is instantiated in response to a
    :func:`ZwpLinuxSurfaceSynchronizationV1.get_release()
    <pywayland.protocol.zwp_linux_explicit_synchronization_unstable_v1.ZwpLinuxSurfaceSynchronizationV1.get_release>`
    request.

    It provides an alternative to :func:`WlBuffer.release()
    <pywayland.protocol.wayland.WlBuffer.release>` events, providing a unique
    release from a single :func:`WlSurface.commit()
    <pywayland.protocol.wayland.WlSurface.commit>` request. The release event
    also supports explicit synchronization, providing a fence FD for the client
    to synchronize against.

    Exactly one event, either a fenced_release or an immediate_release, will be
    emitted for the :func:`WlSurface.commit()
    <pywayland.protocol.wayland.WlSurface.commit>` request. The compositor can
    choose release by release which event it uses.

    This event does not replace :func:`WlBuffer.release()
    <pywayland.protocol.wayland.WlBuffer.release>` events; servers are still
    required to send those events.

    Once a buffer release object has delivered a 'fenced_release' or an
    'immediate_release' event it is automatically destroyed.
    """

    name = "zwp_linux_buffer_release_v1"
    version = 1


class ZwpLinuxBufferReleaseV1Proxy(Proxy[ZwpLinuxBufferReleaseV1]):
    interface = ZwpLinuxBufferReleaseV1


class ZwpLinuxBufferReleaseV1Resource(Resource):
    interface = ZwpLinuxBufferReleaseV1

    @ZwpLinuxBufferReleaseV1.event(
        Argument(ArgumentType.FileDescriptor),
    )
    def fenced_release(self, fence: int) -> None:
        """Release buffer with fence

        Sent when the compositor has finalised its usage of the associated
        buffer for the relevant commit, providing a dma_fence which will be
        signaled when all operations by the compositor on that buffer for that
        commit have finished.

        Once the fence has signaled, and assuming the associated buffer is not
        pending release from other :func:`WlSurface.commit()
        <pywayland.protocol.wayland.WlSurface.commit>` requests, no additional
        explicit or implicit synchronization is required to safely reuse or
        destroy the buffer.

        This event destroys the :class:`ZwpLinuxBufferReleaseV1` object.

        :param fence:
            fence for last operation on buffer
        :type fence:
            `ArgumentType.FileDescriptor`
        """
        self._post_event(0, fence)

    @ZwpLinuxBufferReleaseV1.event()
    def immediate_release(self) -> None:
        """Release buffer immediately

        Sent when the compositor has finalised its usage of the associated
        buffer for the relevant commit, and either performed no operations
        using it, or has a guarantee that all its operations on that buffer for
        that commit have finished.

        Once this event is received, and assuming the associated buffer is not
        pending release from other :func:`WlSurface.commit()
        <pywayland.protocol.wayland.WlSurface.commit>` requests, no additional
        explicit or implicit synchronization is required to safely reuse or
        destroy the buffer.

        This event destroys the :class:`ZwpLinuxBufferReleaseV1` object.
        """
        self._post_event(1)


class ZwpLinuxBufferReleaseV1Global(Global):
    interface = ZwpLinuxBufferReleaseV1


ZwpLinuxBufferReleaseV1._gen_c()
ZwpLinuxBufferReleaseV1.proxy_class = ZwpLinuxBufferReleaseV1Proxy
ZwpLinuxBufferReleaseV1.resource_class = ZwpLinuxBufferReleaseV1Resource
ZwpLinuxBufferReleaseV1.global_class = ZwpLinuxBufferReleaseV1Global
