/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions;

import com.intellij.openapi.extensions.PluginDescriptor;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u0011\u001a\u00020\u0003H\u0016R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/extensions/ExtensionPointDescriptor;", "", "name", "", "isNameQualified", "", "className", "isBean", "hasAttributes", "isDynamic", "<init>", "(Ljava/lang/String;ZLjava/lang/String;ZZZ)V", "getQualifiedName", "pluginDescriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "nameEquals", "qualifiedName", "toString", "intellij.platform.extensions"})
@ApiStatus.Internal
public final class ExtensionPointDescriptor {
    @JvmField
    @NotNull
    public final String name;
    @JvmField
    public final boolean isNameQualified;
    @JvmField
    @NotNull
    public final String className;
    @JvmField
    public final boolean isBean;
    @JvmField
    public final boolean hasAttributes;
    @JvmField
    public final boolean isDynamic;

    public ExtensionPointDescriptor(@NotNull String name, boolean isNameQualified, @NotNull String className, boolean isBean, boolean hasAttributes, boolean isDynamic) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        this.name = name;
        this.isNameQualified = isNameQualified;
        this.className = className;
        this.isBean = isBean;
        this.hasAttributes = hasAttributes;
        this.isDynamic = isDynamic;
    }

    @NotNull
    public final String getQualifiedName(@NotNull PluginDescriptor pluginDescriptor) {
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        return this.isNameQualified ? this.name : pluginDescriptor.getPluginId() + '.' + this.name;
    }

    public final boolean nameEquals(@NotNull String qualifiedName, @NotNull PluginDescriptor pluginDescriptor) {
        Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        if (this.isNameQualified) {
            return Intrinsics.areEqual((Object)qualifiedName, (Object)this.name);
        }
        String pluginId = pluginDescriptor.getPluginId().getIdString();
        return qualifiedName.length() == pluginId.length() + 1 + this.name.length() && qualifiedName.charAt(pluginId.length()) == '.' && StringsKt.startsWith$default((String)qualifiedName, (String)pluginId, (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)qualifiedName, (String)this.name, (boolean)false, (int)2, null);
    }

    @NotNull
    public String toString() {
        return "ExtensionPointDescriptor(name=" + this.name + ", isNameQualified=" + this.isNameQualified + ", className=" + this.className + ", isBean=" + this.isBean + ", isDynamic=" + this.isDynamic + ')';
    }
}

