/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.PySmartEnterProcessor;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers.PyFixer;
import com.jetbrains.python.psi.PyConditionalStatementPart;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import org.jetbrains.annotations.NotNull;

public class PyConditionalStatementPartFixer
extends PyFixer<PyConditionalStatementPart> {
    public PyConditionalStatementPartFixer() {
        super(PyConditionalStatementPart.class);
    }

    @Override
    public void doApply(@NotNull Editor editor2, @NotNull PySmartEnterProcessor processor, @NotNull PyConditionalStatementPart statementPart) throws IncorrectOperationException {
        if (editor2 == null) {
            PyConditionalStatementPartFixer.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            PyConditionalStatementPartFixer.$$$reportNull$$$0(1);
        }
        if (statementPart == null) {
            PyConditionalStatementPartFixer.$$$reportNull$$$0(2);
        }
        PyExpression condition = statementPart.getCondition();
        Document document = editor2.getDocument();
        PsiElement colon = PyPsiUtils.getFirstChildOfType((PsiElement)statementPart, (PyElementType)PyTokenTypes.COLON);
        if (colon == null) {
            if (condition != null) {
                PsiElement firstNonComment = PyPsiUtils.getNextNonCommentSibling((PsiElement)condition.getNextSibling(), (boolean)false);
                if (firstNonComment != null && !":".equals(firstNonComment.getNode().getText())) {
                    document.insertString(firstNonComment.getTextRange().getEndOffset(), (CharSequence)":");
                }
            } else {
                TokenSet keywords = TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.IF_KEYWORD, PyTokenTypes.ELIF_KEYWORD, PyTokenTypes.WHILE_KEYWORD});
                PsiElement keywordToken = PyPsiUtils.getChildByFilter((PsiElement)statementPart, (TokenSet)keywords, (int)0);
                int offset = ((PsiElement)PyUtil.sure((Object)keywordToken)).getTextRange().getEndOffset();
                document.insertString(offset, (CharSequence)" :");
                processor.registerUnresolvedError(offset + 1);
            }
        } else if (condition == null) {
            processor.registerUnresolvedError(colon.getTextRange().getStartOffset());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "processor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "statementPart";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/codeInsight/editorActions/smartEnter/fixers/PyConditionalStatementPartFixer";
        objectArray[2] = "doApply";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

