/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.util.RawParseUtils;

public abstract class QuotedString {
    public static final GitPathStyle GIT_PATH = new GitPathStyle(true);
    public static final QuotedString GIT_PATH_MINIMAL = new GitPathStyle(false);
    public static final BourneStyle BOURNE = new BourneStyle();
    public static final BourneUserPathStyle BOURNE_USER_PATH = new BourneUserPathStyle();

    public abstract String quote(String var1);

    public String dequote(String in) {
        byte[] b = Constants.encode(in);
        return this.dequote(b, 0, b.length);
    }

    public abstract String dequote(byte[] var1, int var2, int var3);

    public static class BourneStyle
    extends QuotedString {
        @Override
        public String quote(String in) {
            StringBuilder r = new StringBuilder();
            r.append('\'');
            int start = 0;
            int i = 0;
            while (i < in.length()) {
                switch (in.charAt(i)) {
                    case '!': 
                    case '\'': {
                        r.append(in, start, i);
                        r.append('\'');
                        r.append('\\');
                        r.append(in.charAt(i));
                        r.append('\'');
                        start = i + 1;
                    }
                }
                ++i;
            }
            r.append(in, start, i);
            r.append('\'');
            return r.toString();
        }

        @Override
        public String dequote(byte[] in, int ip, int ie) {
            boolean inquote = false;
            byte[] r = new byte[ie - ip];
            int rPtr = 0;
            while (ip < ie) {
                byte b = in[ip++];
                switch (b) {
                    case 39: {
                        inquote = !inquote;
                        break;
                    }
                    case 92: {
                        if (inquote || ip == ie) {
                            r[rPtr++] = b;
                            break;
                        }
                        r[rPtr++] = in[ip++];
                        break;
                    }
                    default: {
                        r[rPtr++] = b;
                    }
                }
            }
            return RawParseUtils.decode(StandardCharsets.UTF_8, r, 0, rPtr);
        }
    }

    public static class BourneUserPathStyle
    extends BourneStyle {
        @Override
        public String quote(String in) {
            if (in.matches("^~[A-Za-z0-9_-]+$")) {
                return String.valueOf(in) + "/";
            }
            if (in.matches("^~[A-Za-z0-9_-]*/.*$")) {
                int i = in.indexOf(47) + 1;
                if (i == in.length()) {
                    return in;
                }
                return String.valueOf(in.substring(0, i)) + super.quote(in.substring(i));
            }
            return super.quote(in);
        }
    }

    public static final class GitPathStyle
    extends QuotedString {
        private static final byte[] quote = new byte[128];
        private final boolean quoteHigh;

        static {
            Arrays.fill(quote, (byte)-1);
            int i = 48;
            while (i <= 57) {
                GitPathStyle.quote[i] = 0;
                ++i;
            }
            i = 97;
            while (i <= 122) {
                GitPathStyle.quote[i] = 0;
                ++i;
            }
            i = 65;
            while (i <= 90) {
                GitPathStyle.quote[i] = 0;
                ++i;
            }
            GitPathStyle.quote[32] = 0;
            GitPathStyle.quote[36] = 0;
            GitPathStyle.quote[37] = 0;
            GitPathStyle.quote[38] = 0;
            GitPathStyle.quote[42] = 0;
            GitPathStyle.quote[43] = 0;
            GitPathStyle.quote[44] = 0;
            GitPathStyle.quote[45] = 0;
            GitPathStyle.quote[46] = 0;
            GitPathStyle.quote[47] = 0;
            GitPathStyle.quote[58] = 0;
            GitPathStyle.quote[59] = 0;
            GitPathStyle.quote[61] = 0;
            GitPathStyle.quote[63] = 0;
            GitPathStyle.quote[64] = 0;
            GitPathStyle.quote[95] = 0;
            GitPathStyle.quote[94] = 0;
            GitPathStyle.quote[124] = 0;
            GitPathStyle.quote[126] = 0;
            GitPathStyle.quote[7] = 97;
            GitPathStyle.quote[8] = 98;
            GitPathStyle.quote[12] = 102;
            GitPathStyle.quote[10] = 110;
            GitPathStyle.quote[13] = 114;
            GitPathStyle.quote[9] = 116;
            GitPathStyle.quote[11] = 118;
            GitPathStyle.quote[92] = 92;
            GitPathStyle.quote[34] = 34;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public String quote(String instr) {
            if (instr.isEmpty()) {
                return "\"\"";
            }
            reuse = true;
            in = Constants.encode(instr);
            out = new byte[4 * in.length + 2];
            o = 0;
            out[o++] = 34;
            var9_6 = in;
            var8_7 = in.length;
            var7_8 = 0;
            while (var7_8 < var8_7) {
                block7: {
                    block5: {
                        block6: {
                            element = var9_6[var7_8];
                            c = element & 255;
                            if (c >= GitPathStyle.quote.length) break block5;
                            style = GitPathStyle.quote[c];
                            if (style != 0) break block6;
                            out[o++] = (byte)c;
                            break block7;
                        }
                        if (style <= 0) ** GOTO lbl-1000
                        reuse = false;
                        out[o++] = 92;
                        out[o++] = style;
                        break block7;
                    }
                    if (!this.quoteHigh) {
                        out[o++] = (byte)c;
                    } else lbl-1000:
                    // 2 sources

                    {
                        reuse = false;
                        out[o++] = 92;
                        out[o++] = (byte)((c >> 6 & 3) + 48);
                        out[o++] = (byte)((c >> 3 & 7) + 48);
                        out[o++] = (byte)((c >> 0 & 7) + 48);
                    }
                }
                ++var7_8;
            }
            if (reuse) {
                return instr;
            }
            out[o++] = 34;
            return new String(out, 0, o, StandardCharsets.UTF_8);
        }

        @Override
        public String dequote(byte[] in, int inPtr, int inEnd) {
            if (2 <= inEnd - inPtr && in[inPtr] == 34 && in[inEnd - 1] == 34) {
                return GitPathStyle.dq(in, inPtr + 1, inEnd - 1);
            }
            return RawParseUtils.decode(StandardCharsets.UTF_8, in, inPtr, inEnd);
        }

        private static String dq(byte[] in, int inPtr, int inEnd) {
            byte[] r = new byte[inEnd - inPtr];
            int rPtr = 0;
            while (inPtr < inEnd) {
                byte b;
                if ((b = in[inPtr++]) != 92) {
                    r[rPtr++] = b;
                    continue;
                }
                if (inPtr == inEnd) {
                    r[rPtr++] = 92;
                    break;
                }
                switch (in[inPtr++]) {
                    case 97: {
                        r[rPtr++] = 7;
                        break;
                    }
                    case 98: {
                        r[rPtr++] = 8;
                        break;
                    }
                    case 102: {
                        r[rPtr++] = 12;
                        break;
                    }
                    case 110: {
                        r[rPtr++] = 10;
                        break;
                    }
                    case 114: {
                        r[rPtr++] = 13;
                        break;
                    }
                    case 116: {
                        r[rPtr++] = 9;
                        break;
                    }
                    case 118: {
                        r[rPtr++] = 11;
                        break;
                    }
                    case 34: 
                    case 92: {
                        r[rPtr++] = in[inPtr - 1];
                        break;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: {
                        int cp = in[inPtr - 1] - 48;
                        int n = 1;
                        while (n < 3 && inPtr < inEnd) {
                            byte c = in[inPtr];
                            if (48 > c || c > 55) break;
                            cp <<= 3;
                            cp |= c - 48;
                            ++inPtr;
                            ++n;
                        }
                        r[rPtr++] = (byte)cp;
                        break;
                    }
                    default: {
                        r[rPtr++] = 92;
                        r[rPtr++] = in[inPtr - 1];
                    }
                }
            }
            return RawParseUtils.decode(StandardCharsets.UTF_8, r, 0, rPtr);
        }

        private GitPathStyle(boolean doQuote) {
            this.quoteHigh = doQuote;
        }
    }
}

