/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.intentions.PyTypeHintGenerationUtil;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.documentation.PythonDocumentationProvider;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyMakeFunctionReturnTypeQuickFix
extends PsiUpdateModCommandAction<PyFunction> {
    private final String myReturnTypeName;
    private final String myReturnTypeFqName;

    public PyMakeFunctionReturnTypeQuickFix(@NotNull PyFunction function, @NotNull TypeEvalContext context) {
        if (function == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(1);
        }
        super((PsiElement)function);
        PyType type = PyMakeFunctionReturnTypeQuickFix.getReturnType(function, context);
        this.myReturnTypeName = PythonDocumentationProvider.getTypeHint(type, context);
        this.myReturnTypeFqName = PythonDocumentationProvider.getFullyQualifiedTypeHint(type, context);
    }

    @Nullable
    private static PyType getReturnType(@NotNull PyFunction function, @NotNull TypeEvalContext context) {
        Ref<PyType> unwrappedType;
        if (function == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(2);
        }
        if (context == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(3);
        }
        PyType type = function.getInferredReturnType(context);
        if (function.isAsync() && (unwrappedType = PyTypingTypeProvider.unwrapCoroutineReturnType(type)) != null) {
            type = (PyType)unwrappedType.get();
        }
        return type;
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PyFunction function) {
        if (context == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(4);
        }
        if (function == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(5);
        }
        return Presentation.of((String)PyPsiBundle.message("QFIX.make.function.return.type", function.getName(), this.myReturnTypeName));
    }

    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("QFIX.NAME.make.function.return.type", new Object[0]);
        if (string == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PyFunction function, @NotNull ModPsiUpdater updater) {
        PsiComment typeComment;
        PyExpression annotationExpr;
        if (context == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(7);
        }
        if (function == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(8);
        }
        if (updater == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(9);
        }
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance((Project)function.getProject());
        PyAnnotation annotation = function.getAnnotation();
        if (annotation != null && (annotationExpr = annotation.getValue()) != null) {
            annotationExpr.replace((PsiElement)elementGenerator.createExpressionFromText(LanguageLevel.PYTHON34, this.myReturnTypeName));
            PyTypeHintGenerationUtil.addImportsForTypeAnnotations(List.of(this.myReturnTypeFqName), (PsiElement)function);
        }
        if ((typeComment = function.getTypeComment()) != null) {
            StringBuilder typeCommentAnnotation = new StringBuilder(typeComment.getText());
            typeCommentAnnotation.delete(typeCommentAnnotation.indexOf("->"), typeCommentAnnotation.length());
            typeCommentAnnotation.append("-> ").append(this.myReturnTypeName);
            typeComment.replace((PsiElement)elementGenerator.createFromText(LanguageLevel.PYTHON27, PsiComment.class, typeCommentAnnotation.toString()));
            PyTypeHintGenerationUtil.addImportsForTypeAnnotations(List.of(this.myReturnTypeFqName), (PsiElement)function);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/PyMakeFunctionReturnTypeQuickFix";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/PyMakeFunctionReturnTypeQuickFix";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

