/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.run.ui.GridDataSupport;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import org.jetbrains.annotations.NotNull;

public class RevertMutations
extends DumbAwareAction
implements GridAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            RevertMutations.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        DataGrid grid;
        if (e == null) {
            RevertMutations.$$$reportNull$$$0(1);
        }
        if ((grid = GridUtil.getDataGrid(e.getDataContext())) == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        GridDataSupport support = grid.getDataSupport();
        boolean hasChanges = support.hasPendingChanges() || support.getInsertedColumnsCount() > 0;
        boolean visible = (!support.isSubmitImmediately() || hasChanges) && !grid.getDataHookup().isReadOnly() && !GridUtil.hideEditActions(grid, e.getPlace());
        boolean enabled = visible && hasChanges && support.canRevert() && RevertMutations.hasChangeUnderSelection(grid);
        e.getPresentation().setVisible(visible);
        e.getPresentation().setEnabled(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataGrid grid;
        if (e == null) {
            RevertMutations.$$$reportNull$$$0(2);
        }
        if ((grid = GridUtil.getDataGrid(e.getDataContext())) == null || !grid.getDataSupport().hasRowMutator()) {
            return;
        }
        GridDataSupport support = grid.getDataSupport();
        ModelIndexSet columns = grid.getSelectionModel().getSelectedColumns();
        ModelIndexSet rows = grid.getSelectionModel().getSelectedRows();
        if (columns.size() != 0 && rows.size() != 0) {
            support.revert(rows, columns);
        }
    }

    private static boolean hasChangeUnderSelection(@NotNull DataGrid grid) {
        if (grid == null) {
            RevertMutations.$$$reportNull$$$0(3);
        }
        SelectionModel model2 = grid.getSelectionModel();
        ModelIndexSet rows = model2.getSelectedRows();
        ModelIndexSet columns = model2.getSelectedColumns();
        GridDataSupport support = grid.getDataSupport();
        if (columns.asIterable().find(column -> support.isDeletedColumn(column) || support.isInsertedColumn(column)) != null) {
            return true;
        }
        for (ModelIndex rowIdx : rows.asIterable()) {
            ModelIndexSet rowIdxSet = ModelIndexSet.forRows((CoreGrid)grid, (int[])new int[]{rowIdx.asInteger()});
            if (support.isDeletedRows(rowIdxSet) || GridUtil.isInsertedRow(grid, (ModelIndex<GridRow>)rowIdx)) {
                return true;
            }
            for (ModelIndex columnIdx : columns.asIterable()) {
                if (!support.isModified(rowIdx, columnIdx)) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/RevertMutations";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/RevertMutations";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasChangeUnderSelection";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

