/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Container;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.core.Robot;
import org.assertj.swing.core.matcher.JButtonMatcher;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.driver.ComponentPreconditions;
import org.assertj.swing.driver.JComponentDriver;
import org.assertj.swing.driver.JFileChooserApproveButtonTextQuery;
import org.assertj.swing.driver.JFileChooserCancelButtonTextQuery;
import org.assertj.swing.driver.JFileChooserSelectFileTask;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.internal.annotation.InternalApi;

@InternalApi
public class JFileChooserDriver
extends JComponentDriver {
    public JFileChooserDriver(@Nonnull Robot robot) {
        super(robot);
    }

    @RunsInEDT
    public void selectFile(@Nonnull JFileChooser fileChooser, @Nonnull File file) {
        JFileChooserSelectFileTask.setSelectedFile(fileChooser, (File)Preconditions.checkNotNull((Object)file));
    }

    public void selectFiles(@Nonnull JFileChooser fileChooser, @Nonnull File[] files) {
        Preconditions.checkNotNull((Object)files);
        for (File file : (File[])Preconditions.checkNotNullOrEmpty((Object[])files)) {
            Preconditions.checkNotNull((Object)file);
        }
        JFileChooserSelectFileTask.setSelectedFiles(fileChooser, files);
    }

    @RunsInEDT
    public void setCurrentDirectory(@Nonnull JFileChooser fileChooser, @Nonnull File dir) {
        GuiActionRunner.execute(() -> {
            ComponentPreconditions.checkEnabledAndShowing(fileChooser);
            fileChooser.setCurrentDirectory(dir);
        });
    }

    @RunsInEDT
    public JTextField fileNameTextBox(@Nonnull JFileChooser fileChooser) {
        return this.robot.finder().findByType(fileChooser, JTextField.class);
    }

    @RunsInEDT
    public void clickCancelButton(@Nonnull JFileChooser fileChooser) {
        JFileChooserDriver.checkInEdtEnabledAndShowing(fileChooser);
        this.click(this.cancelButton(fileChooser));
    }

    @Nonnull
    @RunsInEDT
    public JButton cancelButton(@Nonnull JFileChooser fileChooser) {
        return this.findButton(fileChooser, JFileChooserCancelButtonTextQuery.cancelButtonText());
    }

    @RunsInEDT
    public void clickApproveButton(@Nonnull JFileChooser fileChooser) {
        JFileChooserDriver.checkInEdtEnabledAndShowing(fileChooser);
        this.click(this.approveButton(fileChooser));
    }

    @Nonnull
    @RunsInEDT
    public JButton approveButton(@Nonnull JFileChooser fileChooser) {
        return this.findButton(fileChooser, JFileChooserApproveButtonTextQuery.approveButtonTextFrom(fileChooser));
    }

    @Nonnull
    @RunsInEDT
    private JButton findButton(@Nonnull JFileChooser fileChooser, @Nullable String text) {
        return this.robot.finder().find((Container)fileChooser, JButtonMatcher.withText(text).andShowing());
    }
}

