/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.lexer;

import com.intellij.lexer.LexerBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.lexer.PyStringLiteralLexer;
import org.jetbrains.annotations.NotNull;

public abstract class PyStringLiteralLexerBase
extends LexerBase {
    protected static final Logger LOG = Logger.getInstance(PyStringLiteralLexer.class);
    protected final IElementType myOriginalLiteralToken;
    protected CharSequence myBuffer;
    protected int myBufferEnd;
    protected int myStart;
    protected int myEnd;
    protected int myBaseLexerState;
    private boolean mySeenEscapedSpacesOnly;

    public PyStringLiteralLexerBase(IElementType originalLiteralToken) {
        this.myOriginalLiteralToken = originalLiteralToken;
    }

    public final void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            PyStringLiteralLexerBase.$$$reportNull$$$0(0);
        }
        this.myBuffer = buffer;
        this.myStart = startOffset;
        this.mySeenEscapedSpacesOnly = true;
        this.myBufferEnd = endOffset;
        this.myBaseLexerState = initialState;
        this.handleStart(buffer, initialState);
        this.myEnd = this.locateToken(this.myStart);
    }

    protected void handleStart(@NotNull CharSequence buffer, int initialState) {
        if (buffer == null) {
            PyStringLiteralLexerBase.$$$reportNull$$$0(1);
        }
    }

    protected abstract boolean isRaw();

    protected abstract boolean isUnicodeMode();

    public IElementType getTokenType() {
        if (this.myStart >= this.myEnd) {
            return null;
        }
        if (!this.isEscape()) {
            this.mySeenEscapedSpacesOnly = false;
            return this.myOriginalLiteralToken;
        }
        return this.getEscapeSequenceType();
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    @NotNull
    public IElementType getEscapeSequenceType() {
        if (this.myStart + 1 >= this.myEnd) {
            IElementType iElementType = StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN;
            if (iElementType != null) return iElementType;
            PyStringLiteralLexerBase.$$$reportNull$$$0(2);
            return iElementType;
        }
        char nextChar = this.myBuffer.charAt(this.myStart + 1);
        this.mySeenEscapedSpacesOnly &= nextChar == ' ';
        if (nextChar == '\n' || nextChar == ' ' && (this.mySeenEscapedSpacesOnly || this.isTrailingSpace(this.myStart + 2))) {
            IElementType iElementType = StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
            if (iElementType != null) return iElementType;
            PyStringLiteralLexerBase.$$$reportNull$$$0(3);
            return iElementType;
        }
        if (nextChar != 'u' && nextChar != 'U') {
            if (nextChar != 'x') {
                if (nextChar == 'N' && this.isUnicodeMode()) {
                    int i = this.myStart + 2;
                    if (i >= this.myEnd || this.myBuffer.charAt(i) != '{') {
                        IElementType iElementType = StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
                        if (iElementType != null) return iElementType;
                        PyStringLiteralLexerBase.$$$reportNull$$$0(9);
                        return iElementType;
                    }
                    ++i;
                    while (i < this.myEnd && this.myBuffer.charAt(i) != '}') {
                        ++i;
                    }
                    if (i >= this.myEnd) {
                        IElementType iElementType = StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
                        if (iElementType != null) return iElementType;
                        PyStringLiteralLexerBase.$$$reportNull$$$0(10);
                        return iElementType;
                    }
                    IElementType iElementType = StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
                    if (iElementType != null) return iElementType;
                    PyStringLiteralLexerBase.$$$reportNull$$$0(11);
                    return iElementType;
                }
                IElementType iElementType = switch (nextChar) {
                    case '\"', '\'', '0', '1', '2', '3', '4', '5', '6', '7', '\\', 'a', 'b', 'f', 'n', 'r', 't', 'v' -> StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
                    default -> this.myOriginalLiteralToken;
                };
                if (iElementType != null) return iElementType;
                PyStringLiteralLexerBase.$$$reportNull$$$0(12);
                return iElementType;
            }
        } else {
            if (!this.isUnicodeMode()) {
                IElementType iElementType = this.myOriginalLiteralToken;
                if (iElementType != null) return iElementType;
                PyStringLiteralLexerBase.$$$reportNull$$$0(6);
                return iElementType;
            }
            int width = nextChar == 'u' ? 4 : 8;
            int i = this.myStart + 2;
            while (true) {
                if (i >= this.myStart + width + 2) {
                    IElementType iElementType = StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
                    if (iElementType != null) return iElementType;
                    PyStringLiteralLexerBase.$$$reportNull$$$0(5);
                    return iElementType;
                }
                if (i >= this.myEnd || !StringUtil.isHexDigit((char)this.myBuffer.charAt(i))) {
                    IElementType iElementType = StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
                    if (iElementType != null) return iElementType;
                    PyStringLiteralLexerBase.$$$reportNull$$$0(4);
                    return iElementType;
                }
                ++i;
            }
        }
        int i = this.myStart + 2;
        while (true) {
            if (i >= this.myStart + 4) {
                IElementType iElementType = StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
                if (iElementType != null) return iElementType;
                PyStringLiteralLexerBase.$$$reportNull$$$0(8);
                return iElementType;
            }
            if (i >= this.myEnd || !StringUtil.isHexDigit((char)this.myBuffer.charAt(i))) {
                IElementType iElementType = StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
                if (iElementType != null) return iElementType;
                PyStringLiteralLexerBase.$$$reportNull$$$0(7);
                return iElementType;
            }
            ++i;
        }
    }

    protected boolean isEscape() {
        return this.myBuffer.charAt(this.myStart) == '\\' && (!this.isRaw() || this.isUnicodeMode() && this.nextIsUnicodeEscape());
    }

    private boolean nextIsUnicodeEscape() {
        if (this.myStart + 1 < this.myEnd) {
            char nextChar = this.myBuffer.charAt(this.myStart + 1);
            return nextChar == 'u' || nextChar == 'U';
        }
        return false;
    }

    private boolean isTrailingSpace(int start) {
        for (int i = start; i < this.myBufferEnd; i += 2) {
            char c = this.myBuffer.charAt(i);
            if (c != '\\') {
                return false;
            }
            if (i == this.myBufferEnd - 1) {
                return false;
            }
            if (this.myBuffer.charAt(i + 1) == ' ') continue;
            return false;
        }
        return true;
    }

    public final int getTokenStart() {
        assert (this.myStart < this.myEnd || this.myStart == this.myEnd && this.myEnd == this.myBufferEnd);
        return this.myStart;
    }

    public final int getTokenEnd() {
        if (this.myStart >= this.myEnd && (this.myStart != this.myEnd || this.myEnd != this.myBufferEnd)) {
            LOG.error("myStart=" + this.myStart + " myEnd=" + this.myEnd + " myBufferEnd=" + this.myBufferEnd + " text=" + String.valueOf(this.myBuffer.subSequence(this.myStart, this.myBufferEnd)));
        }
        return this.myEnd;
    }

    public final int getBufferEnd() {
        return this.myBufferEnd;
    }

    @NotNull
    public final CharSequence getBufferSequence() {
        CharSequence charSequence = this.myBuffer;
        if (charSequence == null) {
            PyStringLiteralLexerBase.$$$reportNull$$$0(13);
        }
        return charSequence;
    }

    protected abstract int locateToken(int var1);

    protected final int locateEscapeSequence(int start) {
        assert (this.myBuffer.charAt(start) == '\\');
        int i = start;
        ++i;
        if (this.isRaw()) {
            return i;
        }
        if (i == this.myBufferEnd) {
            return i;
        }
        if (this.myBuffer.charAt(i) >= '0' && this.myBuffer.charAt(i) <= '7') {
            char first = this.myBuffer.charAt(i);
            if (++i < this.myBufferEnd && this.myBuffer.charAt(i) >= '0' && this.myBuffer.charAt(i) <= '7' && ++i < this.myBufferEnd && first <= '3' && this.myBuffer.charAt(i) >= '0' && this.myBuffer.charAt(i) <= '7') {
                ++i;
            }
            return i;
        }
        if (this.myBuffer.charAt(i) == 'x') {
            ++i;
            while (i < start + 4) {
                if (this.isEscapeEnd(i)) {
                    return i;
                }
                ++i;
            }
            return i;
        }
        if (this.myBuffer.charAt(i) == 'u' || this.myBuffer.charAt(i) == 'U') {
            int width = this.myBuffer.charAt(i) == 'u' ? 4 : 8;
            ++i;
            while (i < start + width + 2) {
                if (this.isEscapeEnd(i)) {
                    return i;
                }
                ++i;
            }
            return i;
        }
        if (this.myBuffer.charAt(i) == 'N' && this.isUnicodeMode()) {
            ++i;
            while (i < this.myBufferEnd && this.myBuffer.charAt(i) != '}' && this.myBuffer.charAt(i) != '\\') {
                ++i;
            }
            if (i < this.myBufferEnd && this.myBuffer.charAt(i) == '}') {
                ++i;
            }
            return i;
        }
        return i + 1;
    }

    protected boolean isEscapeEnd(int offset) {
        return offset == this.myBufferEnd || this.myBuffer.charAt(offset) == '\n' || this.myBuffer.charAt(offset) == '\\';
    }

    public void advance() {
        this.myStart = this.myEnd;
        this.myEnd = this.locateToken(this.myStart);
        if (this.myStart >= this.myEnd && (this.myStart != this.myEnd || this.myEnd != this.myBufferEnd)) {
            LOG.warn("Inconsistent: start " + this.myStart + ", end " + this.myEnd + ", buf end " + this.myBufferEnd);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/lexer/PyStringLiteralLexerBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/lexer/PyStringLiteralLexerBase";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getEscapeSequenceType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getBufferSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "handleStart";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13 -> new IllegalStateException(string);
        };
    }
}

