/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.AnimationVectorsKt;
import androidx.compose.animation.core.Animations;
import androidx.compose.animation.core.FloatAnimationSpec;
import androidx.compose.animation.core.VectorizedFiniteAnimationSpec;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\n\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0011\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nJ-\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0015J-\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0015J%\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0018J%\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\fR\u0010\u0010\r\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\fR\u0010\u0010\u000e\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u001b"}, d2={"Landroidx/compose/animation/core/VectorizedFloatAnimationSpec;", "V", "Landroidx/compose/animation/core/AnimationVector;", "Landroidx/compose/animation/core/VectorizedFiniteAnimationSpec;", "anims", "Landroidx/compose/animation/core/Animations;", "<init>", "(Landroidx/compose/animation/core/Animations;)V", "anim", "Landroidx/compose/animation/core/FloatAnimationSpec;", "(Landroidx/compose/animation/core/FloatAnimationSpec;)V", "valueVector", "Landroidx/compose/animation/core/AnimationVector;", "velocityVector", "endVelocityVector", "getValueFromNanos", "playTimeNanos", "", "initialValue", "targetValue", "initialVelocity", "(JLandroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)Landroidx/compose/animation/core/AnimationVector;", "getVelocityFromNanos", "getEndVelocity", "(Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)Landroidx/compose/animation/core/AnimationVector;", "getDurationNanos", "(Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)J", "animation-core"})
@StabilityInferred(parameters=0)
public final class VectorizedFloatAnimationSpec<V extends AnimationVector>
implements VectorizedFiniteAnimationSpec<V> {
    @NotNull
    private final Animations anims;
    private V valueVector;
    private V velocityVector;
    private V endVelocityVector;
    public static final int $stable = 8;

    public VectorizedFloatAnimationSpec(@NotNull Animations anims) {
        Intrinsics.checkNotNullParameter((Object)anims, (String)"anims");
        this.anims = anims;
    }

    public VectorizedFloatAnimationSpec(final @NotNull FloatAnimationSpec anim) {
        Intrinsics.checkNotNullParameter((Object)anim, (String)"anim");
        this(new Animations(){

            @Override
            public FloatAnimationSpec get(int index2) {
                return anim;
            }
        });
    }

    @Override
    @NotNull
    public V getValueFromNanos(long playTimeNanos, @NotNull V initialValue, @NotNull V targetValue2, @NotNull V initialVelocity) {
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue2, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        if (this.valueVector == null) {
            this.valueVector = AnimationVectorsKt.newInstance(initialValue);
        }
        int i = 0;
        V v = this.valueVector;
        if (v == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
            v = null;
        }
        int n = ((AnimationVector)v).getSize$animation_core();
        while (i < n) {
            V v2 = this.valueVector;
            if (v2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
                v2 = null;
            }
            ((AnimationVector)v2).set$animation_core(i, this.anims.get(i).getValueFromNanos(playTimeNanos, ((AnimationVector)initialValue).get$animation_core(i), ((AnimationVector)targetValue2).get$animation_core(i), ((AnimationVector)initialVelocity).get$animation_core(i)));
            ++i;
        }
        V v3 = this.valueVector;
        if (v3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
            v3 = null;
        }
        return v3;
    }

    @Override
    @NotNull
    public V getVelocityFromNanos(long playTimeNanos, @NotNull V initialValue, @NotNull V targetValue2, @NotNull V initialVelocity) {
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue2, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        if (this.velocityVector == null) {
            this.velocityVector = AnimationVectorsKt.newInstance(initialVelocity);
        }
        int i = 0;
        V v = this.velocityVector;
        if (v == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
            v = null;
        }
        int n = ((AnimationVector)v).getSize$animation_core();
        while (i < n) {
            V v2 = this.velocityVector;
            if (v2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
                v2 = null;
            }
            ((AnimationVector)v2).set$animation_core(i, this.anims.get(i).getVelocityFromNanos(playTimeNanos, ((AnimationVector)initialValue).get$animation_core(i), ((AnimationVector)targetValue2).get$animation_core(i), ((AnimationVector)initialVelocity).get$animation_core(i)));
            ++i;
        }
        V v3 = this.velocityVector;
        if (v3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
            v3 = null;
        }
        return v3;
    }

    @Override
    @NotNull
    public V getEndVelocity(@NotNull V initialValue, @NotNull V targetValue2, @NotNull V initialVelocity) {
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue2, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        if (this.endVelocityVector == null) {
            this.endVelocityVector = AnimationVectorsKt.newInstance(initialVelocity);
        }
        int i = 0;
        V v = this.endVelocityVector;
        if (v == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"endVelocityVector");
            v = null;
        }
        int n = ((AnimationVector)v).getSize$animation_core();
        while (i < n) {
            V v2 = this.endVelocityVector;
            if (v2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"endVelocityVector");
                v2 = null;
            }
            ((AnimationVector)v2).set$animation_core(i, this.anims.get(i).getEndVelocity(((AnimationVector)initialValue).get$animation_core(i), ((AnimationVector)targetValue2).get$animation_core(i), ((AnimationVector)initialVelocity).get$animation_core(i)));
            ++i;
        }
        V v3 = this.endVelocityVector;
        if (v3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"endVelocityVector");
            v3 = null;
        }
        return v3;
    }

    @Override
    public long getDurationNanos(@NotNull V initialValue, @NotNull V targetValue2, @NotNull V initialVelocity) {
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue2, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        long maxDuration = 0L;
        int n = ((AnimationVector)initialValue).getSize$animation_core();
        for (int i = 0; i < n; ++i) {
            maxDuration = Math.max(maxDuration, this.anims.get(i).getDurationNanos(((AnimationVector)initialValue).get$animation_core(i), ((AnimationVector)targetValue2).get$animation_core(i), ((AnimationVector)initialVelocity).get$animation_core(i)));
        }
        return maxDuration;
    }
}

