/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.community.impl.huggingFace.cache;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.python.community.impl.huggingFace.cache.HuggingFaceCacheUpdateListener;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/python/community/impl/huggingFace/cache/HuggingFaceCacheUpdateHandler;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "connection", "Lcom/intellij/util/messages/MessageBusConnection;", "refreshReferencesInProject", "", "dispose", "intellij.python.community.impl.huggingFace"})
@ApiStatus.Internal
public final class HuggingFaceCacheUpdateHandler
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final MessageBusConnection connection;

    public HuggingFaceCacheUpdateHandler(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.connection = this.project.getMessageBus().connect((Disposable)this);
        this.connection.subscribe(HuggingFaceCacheUpdateListener.Companion.getTOPIC(), (Object)new HuggingFaceCacheUpdateListener(){

            @Override
            public void cacheUpdated() {
                this.refreshReferencesInProject();
            }
        });
    }

    private final void refreshReferencesInProject() {
        ApplicationManager.getApplication().invokeLater(() -> HuggingFaceCacheUpdateHandler.refreshReferencesInProject$lambda$0(this));
    }

    public void dispose() {
        this.connection.disconnect();
    }

    private static final void refreshReferencesInProject$lambda$0(HuggingFaceCacheUpdateHandler this$0) {
        if (this$0.project.isDisposed()) {
            return;
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this$0.project);
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this$0.project);
        VirtualFile[] virtualFileArray = fileEditorManager.getOpenFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getOpenFiles(...)");
        List openFiles = ArraysKt.toList((Object[])virtualFileArray);
        psiDocumentManager.reparseFiles((Collection)openFiles, true);
    }
}

