/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.cloud;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.remoteServer.agent.util.log.TerminalListener;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.ProcessTtyConnector;
import com.jediterm.terminal.TtyConnector;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.AbstractTerminalRunner;
import org.jetbrains.plugins.terminal.ShellStartupOptions;
import org.jetbrains.plugins.terminal.cloud.CloudTerminalProcess;

public class CloudTerminalRunner
extends AbstractTerminalRunner<CloudTerminalProcess> {
    @NlsSafe
    private final String myPipeName;
    private final CloudTerminalProcess myProcess;
    private final TerminalListener.TtyResizeHandler myTtyResizeHandler;

    public CloudTerminalRunner(@NotNull Project project, @NotNull @NlsSafe String pipeName, @NotNull CloudTerminalProcess process, @Nullable TerminalListener.TtyResizeHandler resizeHandler) {
        if (project == null) {
            CloudTerminalRunner.$$$reportNull$$$0(0);
        }
        if (pipeName == null) {
            CloudTerminalRunner.$$$reportNull$$$0(1);
        }
        if (process == null) {
            CloudTerminalRunner.$$$reportNull$$$0(2);
        }
        super(project);
        this.myPipeName = pipeName;
        this.myProcess = process;
        this.myTtyResizeHandler = resizeHandler;
    }

    public CloudTerminalRunner(@NotNull Project project, @NotNull @NlsSafe String pipeName, CloudTerminalProcess process) {
        if (project == null) {
            CloudTerminalRunner.$$$reportNull$$$0(3);
        }
        if (pipeName == null) {
            CloudTerminalRunner.$$$reportNull$$$0(4);
        }
        this(project, pipeName, process, null);
    }

    @Override
    @NotNull
    public CloudTerminalProcess createProcess(@NotNull ShellStartupOptions options) throws ExecutionException {
        if (options == null) {
            CloudTerminalRunner.$$$reportNull$$$0(5);
        }
        CloudTerminalProcess cloudTerminalProcess = this.myProcess;
        if (cloudTerminalProcess == null) {
            CloudTerminalRunner.$$$reportNull$$$0(6);
        }
        return cloudTerminalProcess;
    }

    @Override
    public boolean isTerminalSessionPersistent() {
        return false;
    }

    @Override
    @NotNull
    public TtyConnector createTtyConnector(@NotNull CloudTerminalProcess process) {
        if (process == null) {
            CloudTerminalRunner.$$$reportNull$$$0(7);
        }
        return new ProcessTtyConnector(process, StandardCharsets.UTF_8){

            public void resize(@NotNull TermSize termSize) {
                if (termSize == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (CloudTerminalRunner.this.myTtyResizeHandler != null) {
                    CloudTerminalRunner.this.myTtyResizeHandler.onTtyResizeRequest(termSize.getColumns(), termSize.getRows());
                }
            }

            public String getName() {
                return "Connector: " + CloudTerminalRunner.this.myPipeName;
            }

            public boolean isConnected() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "termSize", "org/jetbrains/plugins/terminal/cloud/CloudTerminalRunner$1", "resize"));
            }
        };
    }

    @Override
    @NotNull
    public String getDefaultTabTitle() {
        return "Cloud terminal";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pipeName";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/cloud/CloudTerminalRunner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/cloud/CloudTerminalRunner";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createProcess";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createTtyConnector";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

