/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.output;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.output.EmptyTextAttributesProvider;
import org.jetbrains.plugins.terminal.block.output.HighlightingInfo;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputModel;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0011\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000bH\u0086\u0002J\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bJ$\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u000bH\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputHighlightingsSnapshot;", "", "document", "Lcom/intellij/openapi/editor/Document;", "highlightings", "", "Lorg/jetbrains/plugins/terminal/block/output/HighlightingInfo;", "<init>", "(Lcom/intellij/openapi/editor/Document;Ljava/util/List;)V", "allSortedHighlightings", "size", "", "getSize", "()I", "get", "index", "findHighlightingIndex", "documentOffset", "buildAndSortHighlightings", "equals", "", "other", "hashCode", "toString", "", "intellij.terminal"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nTerminalOutputHighlightingsSnapshot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalOutputHighlightingsSnapshot.kt\norg/jetbrains/plugins/terminal/block/output/TerminalOutputHighlightingsSnapshot\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,81:1\n1056#2:82\n13#3:83\n13#3:84\n*S KotlinDebug\n*F\n+ 1 TerminalOutputHighlightingsSnapshot.kt\norg/jetbrains/plugins/terminal/block/output/TerminalOutputHighlightingsSnapshot\n*L\n41#1:82\n47#1:83\n50#1:84\n*E\n"})
public final class TerminalOutputHighlightingsSnapshot {
    @NotNull
    private final Document document;
    @NotNull
    private final List<HighlightingInfo> allSortedHighlightings;

    public TerminalOutputHighlightingsSnapshot(@NotNull Document document, @NotNull List<HighlightingInfo> highlightings) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter(highlightings, (String)"highlightings");
        this.document = document;
        this.allSortedHighlightings = this.buildAndSortHighlightings(this.document, highlightings);
    }

    public final int getSize() {
        return this.allSortedHighlightings.size();
    }

    @NotNull
    public final HighlightingInfo get(int index) {
        return this.allSortedHighlightings.get(index);
    }

    public final int findHighlightingIndex(int documentOffset) {
        int insertionIndex;
        if (documentOffset <= 0) {
            return 0;
        }
        int binarySearchInd = CollectionsKt.binarySearch(this.allSortedHighlightings, (int)0, (int)this.allSortedHighlightings.size(), arg_0 -> TerminalOutputHighlightingsSnapshot.findHighlightingIndex$lambda$0(documentOffset, arg_0));
        return binarySearchInd >= 0 ? binarySearchInd : ((insertionIndex = -binarySearchInd - 1) == 0 || insertionIndex == this.allSortedHighlightings.size() && documentOffset >= this.document.getTextLength() ? insertionIndex : insertionIndex - 1);
    }

    private final List<HighlightingInfo> buildAndSortHighlightings(Document document, List<HighlightingInfo> highlightings) {
        Iterable $this$sortedBy$iv = highlightings;
        boolean $i$f$sortedBy = false;
        List sortedHighlightings = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                HighlightingInfo it = (HighlightingInfo)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getStartOffset());
                it = (HighlightingInfo)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getStartOffset()));
            }
        });
        int documentLength = document.getTextLength();
        List result2 = new ArrayList(sortedHighlightings.size() * 2 + 1);
        int startOffset = 0;
        for (HighlightingInfo highlighting : sortedHighlightings) {
            boolean $i$f$logger;
            if (highlighting.getStartOffset() < 0 || highlighting.getEndOffset() > documentLength) {
                $i$f$logger = false;
                Logger logger = Logger.getInstance(TerminalOutputModel.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Terminal highlightings range should be within document");
            }
            if (startOffset > highlighting.getStartOffset()) {
                $i$f$logger = false;
                Logger logger = Logger.getInstance(TerminalOutputModel.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Terminal highlightings should not overlap");
            }
            if (startOffset < highlighting.getStartOffset()) {
                result2.add(new HighlightingInfo(startOffset, highlighting.getStartOffset(), EmptyTextAttributesProvider.INSTANCE));
            }
            result2.add(highlighting);
            startOffset = highlighting.getEndOffset();
        }
        if (startOffset < documentLength) {
            result2.add(new HighlightingInfo(startOffset, documentLength, EmptyTextAttributesProvider.INSTANCE));
        }
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.jetbrains.plugins.terminal.block.output.TerminalOutputHighlightingsSnapshot");
        TerminalOutputHighlightingsSnapshot cfr_ignored_0 = (TerminalOutputHighlightingsSnapshot)object2;
        return Intrinsics.areEqual(this.allSortedHighlightings, ((TerminalOutputHighlightingsSnapshot)other).allSortedHighlightings);
    }

    public int hashCode() {
        return ((Object)this.allSortedHighlightings).hashCode();
    }

    @NotNull
    public String toString() {
        return "TerminalOutputHighlightingsSnapshot(allSortedHighlightings=" + this.allSortedHighlightings + ")";
    }

    private static final int findHighlightingIndex$lambda$0(int $documentOffset, HighlightingInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.compare((int)it.getStartOffset(), (int)$documentOffset);
    }
}

