/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ModuleContextProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractConvertContext
extends ConvertContext {
    @Override
    public final XmlTag getTag() {
        return this.getInvocationElement().getXmlTag();
    }

    @Override
    @Nullable
    public XmlElement getXmlElement() {
        return this.getInvocationElement().getXmlElement();
    }

    @Override
    @NotNull
    public final XmlFile getFile() {
        XmlFile xmlFile = DomUtil.getFile(this.getInvocationElement());
        if (xmlFile == null) {
            AbstractConvertContext.$$$reportNull$$$0(0);
        }
        return xmlFile;
    }

    @Override
    public Module getModule() {
        DomFileElement fileElement = DomUtil.getFileElement(this.getInvocationElement());
        if (fileElement == null) {
            XmlElement xmlElement = this.getInvocationElement().getXmlElement();
            return xmlElement == null ? null : ModuleUtilCore.findModuleForPsiElement((PsiElement)xmlElement);
        }
        return fileElement.isValid() ? fileElement.getRootElement().getModule() : null;
    }

    @Override
    @Nullable
    public GlobalSearchScope getSearchScope() {
        GlobalSearchScope scope = null;
        Module[] modules = this.getConvertContextModules();
        if (modules.length != 0) {
            XmlFile file = this.getFile();
            VirtualFile virtualFile = (file = file.getOriginalFile()).getVirtualFile();
            if (virtualFile != null) {
                boolean tests = TestSourcesFilter.isTestSources((VirtualFile)virtualFile, (Project)file.getProject());
                for (Module module : modules) {
                    scope = scope == null ? module.getModuleRuntimeScope(tests) : scope.union((SearchScope)module.getModuleRuntimeScope(tests));
                }
            }
        }
        return scope;
    }

    private Module @NotNull [] getConvertContextModules() {
        Module[] modules = ModuleContextProvider.getModules((PsiFile)this.getFile());
        if (modules.length > 0) {
            if (modules == null) {
                AbstractConvertContext.$$$reportNull$$$0(1);
            }
            return modules;
        }
        Module module = this.getModule();
        if (module != null) {
            Module[] moduleArray = new Module[]{module};
            if (moduleArray == null) {
                AbstractConvertContext.$$$reportNull$$$0(2);
            }
            return moduleArray;
        }
        if (Module.EMPTY_ARRAY == null) {
            AbstractConvertContext.$$$reportNull$$$0(3);
        }
        return Module.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/util/xml/AbstractConvertContext";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConvertContextModules";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

