/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.io.URLUtil;
import java.net.URL;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Html5SchemaProvider {
    private static final Logger LOG = Logger.getInstance(Html5SchemaProvider.class);
    private static final Supplier<String> HTML5_SCHEMA_LOCATION = new SynchronizedClearableLazy(() -> {
        Html5SchemaProvider provider = Html5SchemaProvider.getInstance();
        return provider != null ? Html5SchemaProvider.loadLocation(provider.getHtmlSchemaLocation(), "HTML5_SCHEMA") : "";
    });
    private static final Supplier<String> XHTML5_SCHEMA_LOCATION = new SynchronizedClearableLazy(() -> {
        Html5SchemaProvider provider = Html5SchemaProvider.getInstance();
        return provider != null ? Html5SchemaProvider.loadLocation(provider.getXhtmlSchemaLocation(), "XHTML5_SCHEMA") : "";
    });
    private static final Supplier<String> CHARS_DTD_LOCATION = new SynchronizedClearableLazy(() -> {
        Html5SchemaProvider provider = Html5SchemaProvider.getInstance();
        return provider != null ? Html5SchemaProvider.loadLocation(provider.getCharsLocation(), "CHARS_DTD") : "";
    });

    @NotNull
    private static String loadLocation(URL url, String id) {
        String location = VfsUtilCore.urlToPath((String)VfsUtilCore.fixURLforIDEA((String)URLUtil.unescapePercentSequences((String)url.toExternalForm())));
        LOG.info(id + "_LOCATION = " + location);
        String string = location;
        if (string == null) {
            Html5SchemaProvider.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public static String getHtml5SchemaLocation() {
        String string = HTML5_SCHEMA_LOCATION.get();
        if (string == null) {
            Html5SchemaProvider.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String getXhtml5SchemaLocation() {
        String string = XHTML5_SCHEMA_LOCATION.get();
        if (string == null) {
            Html5SchemaProvider.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static String getCharsDtdLocation() {
        String string = CHARS_DTD_LOCATION.get();
        if (string == null) {
            Html5SchemaProvider.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    private static Html5SchemaProvider getInstance() {
        return (Html5SchemaProvider)ApplicationManager.getApplication().getService(Html5SchemaProvider.class);
    }

    @NotNull
    protected abstract URL getHtmlSchemaLocation();

    @NotNull
    protected abstract URL getXhtmlSchemaLocation();

    @NotNull
    protected abstract URL getCharsLocation();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/xml/Html5SchemaProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "loadLocation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getHtml5SchemaLocation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getXhtml5SchemaLocation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharsDtdLocation";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

