/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extensions;

import com.intellij.database.DataGridBundle;
import com.intellij.database.datagrid.DataGridNotifications;
import com.intellij.database.extensions.Binding;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.ide.script.IdeScriptEngine;
import com.intellij.ide.script.IdeScriptEngineManager;
import com.intellij.ide.script.IdeScriptException;
import com.intellij.ide.ui.IdeUiService;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExtensionScriptsUtil {
    private static final String JS_PLUGIN_ID = "org.jetbrains.intellij.scripting-javascript";
    private static final String JS_PLUGIN_NAME = "IntelliJ Scripting: JavaScript";

    private ExtensionScriptsUtil() {
    }

    @Nullable
    public static IdeScriptEngine getEngineFor(@Nullable Project project, @Nullable PluginId pluginId, @NotNull Path file, @Nullable BiConsumer<String, Project> installPlugin) {
        if (file == null) {
            ExtensionScriptsUtil.$$$reportNull$$$0(0);
        }
        return ExtensionScriptsUtil.getEngineFor(project, pluginId, file, installPlugin, true);
    }

    @Nullable
    public static IdeScriptEngine getEngineFor(@Nullable Project project, @Nullable PluginId pluginId, @NotNull Path file, @Nullable BiConsumer<String, Project> installPlugin, boolean showBalloon) {
        if (file == null) {
            ExtensionScriptsUtil.$$$reportNull$$$0(1);
        }
        return ExtensionScriptsUtil.getEngineFor(project, ExtensionScriptsUtil.getClassLoader(pluginId), file, installPlugin, showBalloon);
    }

    @Nullable
    public static ClassLoader getClassLoader(@Nullable PluginId pluginId) {
        IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin((PluginId)pluginId);
        plugin = plugin != null ? plugin : PluginManagerCore.getPlugin((PluginId)PluginManagerCore.CORE_ID);
        IdeaPluginDescriptor descriptor = Objects.requireNonNull(plugin);
        return descriptor.getPluginClassLoader();
    }

    @Nullable
    public static IdeScriptEngine getEngineFor(@Nullable Project project, ClassLoader baseLoader, @NotNull Path file, @Nullable BiConsumer<String, Project> installPlugin, boolean showBalloon) {
        String scriptExtension;
        if (file == null) {
            ExtensionScriptsUtil.$$$reportNull$$$0(2);
        }
        if ("js".equals(scriptExtension = FileUtilRt.getExtension((String)file.getFileName().toString()))) {
            System.setProperty("polyglot.js.nashorn-compat", "true");
        }
        ClassLoader loader = ExtensionScriptsUtil.makeCancellable(baseLoader);
        IdeScriptEngine engine = IdeScriptEngineManager.getInstance().getEngineByFileExtension(scriptExtension, loader);
        if (engine != null || !showBalloon) {
            return engine;
        }
        ExtensionScriptsUtil.showEngineNotFoundBalloon(project, installPlugin, scriptExtension);
        return null;
    }

    private static ClassLoader makeCancellable(ClassLoader loader) {
        return new ClassLoader("Cancellable Engine Classloader", loader){

            @Override
            protected Object getClassLoadingLock(String className) {
                ProgressManager.checkCanceled();
                return super.getClassLoadingLock(className);
            }
        };
    }

    public static void showEngineNotFoundBalloon(final @Nullable Project project, final @Nullable BiConsumer<String, Project> installPlugin, String scriptExtension) {
        String title = DataGridBundle.message("notification.title.no.script.engine.found.for.file.extension", scriptExtension);
        if ("js".equals(scriptExtension)) {
            String content = DataGridBundle.message("notification.please.install.js.script.engine", JS_PLUGIN_NAME);
            Notification notification = DataGridNotifications.EXTRACTORS_GROUP.createNotification(title, content, NotificationType.INFORMATION);
            if (installPlugin != null) {
                notification.addAction((AnAction)new NotificationAction(DataGridBundle.message("notification.install.plugin", new Object[0])){

                    public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                        if (e == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        if (notification == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        installPlugin.accept(ExtensionScriptsUtil.JS_PLUGIN_ID, project);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "e";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "notification";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/database/extensions/ExtensionScriptsUtil$2";
                        objectArray[2] = "actionPerformed";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
            notification.notify(project);
        } else {
            String content = DataGridBundle.message("notification.content.please.make.sure.your.script.engine.jar.s.language.runtime.are.in.ide.classpath", new Object[0]);
            ExtensionScriptsUtil.showError(project, title, content);
        }
    }

    @NotNull
    public static Binder setBindings(@NotNull IdeScriptEngine engine) {
        if (engine == null) {
            ExtensionScriptsUtil.$$$reportNull$$$0(3);
        }
        return new Binder(engine);
    }

    public static void prepareScript(@NotNull Path script) {
        if (script == null) {
            ExtensionScriptsUtil.$$$reportNull$$$0(4);
        }
        ThreadingAssertions.assertEventDispatchThread();
        FileDocumentManager.getInstance().saveAllDocuments();
    }

    @NotNull
    public static String loadScript(@Nullable Project project, @NotNull Path script) throws IOException {
        String string;
        if (script == null) {
            ExtensionScriptsUtil.$$$reportNull$$$0(5);
        }
        try {
            string = Files.readString(script);
        }
        catch (IOException e) {
            ExtensionScriptsUtil.showError(project, DataGridBundle.message("notification.title.failed.to.load.script", script.toString()), ExceptionUtil.getThrowableText((Throwable)e));
            throw e;
        }
        if (string == null) {
            ExtensionScriptsUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    public static Object evalScript(@Nullable Project project, @NotNull IdeScriptEngine engine, @NotNull Path scriptFile) throws IdeScriptException {
        if (engine == null) {
            ExtensionScriptsUtil.$$$reportNull$$$0(7);
        }
        if (scriptFile == null) {
            ExtensionScriptsUtil.$$$reportNull$$$0(8);
        }
        return ExtensionScriptsUtil.evalScript(project, engine, scriptFile, true);
    }

    public static Object evalScript(@Nullable Project project, @NotNull IdeScriptEngine engine, @NotNull Path scriptFile, boolean showErrorMessage) throws IdeScriptException {
        if (engine == null) {
            ExtensionScriptsUtil.$$$reportNull$$$0(9);
        }
        if (scriptFile == null) {
            ExtensionScriptsUtil.$$$reportNull$$$0(10);
        }
        try {
            String script = ExtensionScriptsUtil.loadScript(project, scriptFile);
            return engine.eval(script);
        }
        catch (IOException e) {
            throw new IdeScriptException("Failed to load " + String.valueOf(scriptFile), (Throwable)e);
        }
        catch (IdeScriptException e) {
            ProgressManager.checkCanceled();
            ProcessCanceledException pce = (ProcessCanceledException)ExceptionUtil.findCause((Throwable)e, ProcessCanceledException.class);
            if (pce != null) {
                throw pce;
            }
            if (showErrorMessage) {
                ExtensionScriptsUtil.showScriptExecutionError(project, scriptFile, ExceptionUtil.getRootCause((Throwable)e));
            }
            throw e;
        }
    }

    public static void showScriptExecutionError(@Nullable Project project, @NotNull Path scriptFile, @NotNull Throwable error) {
        if (scriptFile == null) {
            ExtensionScriptsUtil.$$$reportNull$$$0(11);
        }
        if (error == null) {
            ExtensionScriptsUtil.$$$reportNull$$$0(12);
        }
        DataGridNotifications.EXTRACTORS_GROUP.createNotification("<a href=\"generator\">" + String.valueOf(scriptFile.getFileName()) + "</a>: " + ExceptionUtil.getThrowableText((Throwable)error, (String)"com.intellij."), NotificationType.ERROR).setListener((notification, event) -> ExtensionScriptsUtil.navigateToFile(project, scriptFile)).notify(project);
    }

    public static void showError(@Nullable Project project, @NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String content) {
        if (title == null) {
            ExtensionScriptsUtil.$$$reportNull$$$0(13);
        }
        if (content == null) {
            ExtensionScriptsUtil.$$$reportNull$$$0(14);
        }
        DataGridNotifications.EXTRACTORS_GROUP.createNotification(title, content, NotificationType.ERROR).notify(project);
    }

    public static boolean navigateToFile(@Nullable Project project, @NotNull Path file) {
        if (file == null) {
            ExtensionScriptsUtil.$$$reportNull$$$0(15);
        }
        ProjectFileIndex index = project == null ? null : ProjectFileIndex.getInstance((Project)project);
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByNioFile(file);
        if (index != null && virtualFile != null && virtualFile.isValid() && (ScratchUtil.isScratch((VirtualFile)virtualFile) || index.isInContent(virtualFile) || index.isInLibrary(virtualFile))) {
            new OpenFileDescriptor(project, virtualFile).navigate(true);
        } else if (Files.exists(file, new LinkOption[0])) {
            IdeUiService.getInstance().revealFile(file);
        } else {
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "engine";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "script";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extensions/ExtensionScriptsUtil";
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extensions/ExtensionScriptsUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "loadScript";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEngineFor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setBindings";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "prepareScript";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadScript";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "evalScript";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "showScriptExecutionError";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "showError";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "navigateToFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }

    public static class Binder {
        private final IdeScriptEngine myEngine;

        Binder(@NotNull IdeScriptEngine engine) {
            if (engine == null) {
                Binder.$$$reportNull$$$0(0);
            }
            this.myEngine = engine;
        }

        @NotNull
        public <T> Binder bind(@NotNull Binding<T> what, @Nullable T to) {
            if (what == null) {
                Binder.$$$reportNull$$$0(1);
            }
            this.myEngine.setBinding(what.name, to);
            Binder binder = this;
            if (binder == null) {
                Binder.$$$reportNull$$$0(2);
            }
            return binder;
        }

        public static <T> T get(@NotNull IdeScriptEngine engine, @NotNull Binding<T> what) {
            if (engine == null) {
                Binder.$$$reportNull$$$0(3);
            }
            if (what == null) {
                Binder.$$$reportNull$$$0(4);
            }
            return (T)engine.getBinding(what.name);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "engine";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "what";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/extensions/ExtensionScriptsUtil$Binder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/extensions/ExtensionScriptsUtil$Binder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "bind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "bind";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "get";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

