/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.statistics.IOStatisticsSnapshot;
import org.apache.hadoop.fs.statistics.IOStatisticsSupport;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.TaskManifest;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.AbstractJobOrTaskStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.SaveTaskManifestStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.StageConfig;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.TaskAttemptScanDirectoryStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitTaskStage
extends AbstractJobOrTaskStage<Void, Result> {
    private static final Logger LOG = LoggerFactory.getLogger(CommitTaskStage.class);

    public CommitTaskStage(StageConfig stageConfig) {
        super(true, stageConfig, "task_stage_commit", false);
    }

    @Override
    protected Result executeStage(Void arguments) throws IOException {
        LOG.info("{}: Committing task \"{}\"", (Object)this.getName(), (Object)this.getTaskAttemptId());
        TaskAttemptScanDirectoryStage scanStage = new TaskAttemptScanDirectoryStage(this.getStageConfig());
        TaskManifest manifest = (TaskManifest)scanStage.apply(arguments);
        scanStage.addExecutionDurationToStatistics(this.getIOStatistics(), "task_stage_commit");
        IOStatisticsSnapshot manifestStats = IOStatisticsSupport.snapshotIOStatistics();
        manifestStats.aggregate(this.getIOStatistics());
        manifest.setIOStatistics(manifestStats);
        Path manifestPath = (Path)new SaveTaskManifestStage(this.getStageConfig()).apply(manifest);
        return new Result(manifestPath, manifest);
    }

    public static final class Result {
        private final Path path;
        private final TaskManifest taskManifest;

        public Result(Path path, TaskManifest taskManifest) {
            this.path = path;
            this.taskManifest = taskManifest;
        }

        public Path getPath() {
            return this.path;
        }

        public TaskManifest getTaskManifest() {
            return this.taskManifest;
        }
    }
}

