/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.dynamodb.transforms.model;

import java.util.Objects;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;

public class ScanOutputTransformInput {
    private final ScanResponse sdkOutput;
    private final ScanRequest originalInput;

    protected ScanOutputTransformInput(BuilderImpl builder) {
        this.sdkOutput = builder.sdkOutput();
        this.originalInput = builder.originalInput();
    }

    public ScanResponse sdkOutput() {
        return this.sdkOutput;
    }

    public ScanRequest originalInput() {
        return this.originalInput;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected ScanResponse sdkOutput;
        protected ScanRequest originalInput;

        protected BuilderImpl() {
        }

        protected BuilderImpl(ScanOutputTransformInput model) {
            this.sdkOutput = model.sdkOutput();
            this.originalInput = model.originalInput();
        }

        @Override
        public Builder sdkOutput(ScanResponse sdkOutput) {
            this.sdkOutput = sdkOutput;
            return this;
        }

        @Override
        public ScanResponse sdkOutput() {
            return this.sdkOutput;
        }

        @Override
        public Builder originalInput(ScanRequest originalInput) {
            this.originalInput = originalInput;
            return this;
        }

        @Override
        public ScanRequest originalInput() {
            return this.originalInput;
        }

        @Override
        public ScanOutputTransformInput build() {
            if (Objects.isNull(this.sdkOutput())) {
                throw new IllegalArgumentException("Missing value for required field `sdkOutput`");
            }
            if (Objects.isNull(this.originalInput())) {
                throw new IllegalArgumentException("Missing value for required field `originalInput`");
            }
            return new ScanOutputTransformInput(this);
        }
    }

    public static interface Builder {
        public Builder sdkOutput(ScanResponse var1);

        public ScanResponse sdkOutput();

        public Builder originalInput(ScanRequest var1);

        public ScanRequest originalInput();

        public ScanOutputTransformInput build();
    }
}

