/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.mcpserver;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.server.McpServer;
import io.modelcontextprotocol.server.McpStatelessAsyncServer;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpStatelessServerTransport;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.action.mcpserver.McpToolsHelper;
import org.opensearch.ml.action.mcpserver.OpenSearchMcpStatelessServerTransportProvider;
import org.opensearch.ml.common.transport.mcpserver.requests.McpToolBaseInput;
import org.opensearch.ml.common.transport.mcpserver.requests.register.McpToolRegisterInput;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;
import reactor.core.publisher.Mono;

public class McpStatelessServerHolder {
    @Generated
    private static final Logger log = LogManager.getLogger(McpStatelessServerHolder.class);
    private final McpToolsHelper mcpToolsHelper;
    private final Client client;
    private final ThreadPool threadPool;
    private static final int SYNC_MCP_TOOLS_JOB_INTERVAL = 10;
    public static Map<String, Long> IN_MEMORY_MCP_TOOLS = new ConcurrentHashMap<String, Long>();
    private static volatile McpStatelessAsyncServer mcpStatelessAsyncServer;
    private static volatile OpenSearchMcpStatelessServerTransportProvider mcpStatelessServerTransportProvider;
    private static volatile Boolean initialized;

    public McpStatelessServerHolder(McpToolsHelper mcpToolsHelper, Client client, ThreadPool threadPool) {
        this.mcpToolsHelper = mcpToolsHelper;
        this.client = client;
        this.threadPool = threadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        if (initialized.booleanValue()) {
            return;
        }
        Class<McpStatelessServerHolder> clazz = McpStatelessServerHolder.class;
        synchronized (McpStatelessServerHolder.class) {
            if (initialized.booleanValue()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            try {
                mcpStatelessServerTransportProvider = new OpenSearchMcpStatelessServerTransportProvider(new ObjectMapper());
                McpSchema.ServerCapabilities serverCapabilities = McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).logging().resources(Boolean.valueOf(false), Boolean.valueOf(false)).prompts(Boolean.valueOf(false)).build();
                log.info("Building MCP server ...");
                mcpStatelessAsyncServer = McpServer.async((McpStatelessServerTransport)mcpStatelessServerTransportProvider).serverInfo("OpenSearch-MCP-Stateless-Server", "0.1.0").capabilities(serverCapabilities).instructions("OpenSearch MCP Stateless Server - provides access to ML tools without sessions").build();
                log.info("Stateless MCP server created successfully");
                this.autoLoadAllMcpTools((ActionListener<Boolean>)ActionListener.wrap(success -> log.info("Initial tool loading completed successfully"), error -> log.error("Initial tool loading failed", (Throwable)error)));
                initialized = true;
            }
            catch (Exception e) {
                log.error("Failed to create stateless MCP server", (Throwable)e);
                throw new RuntimeException("Failed to create stateless MCP server", e);
            }
            return;
        }
    }

    public OpenSearchMcpStatelessServerTransportProvider getMcpStatelessServerTransportProvider() {
        if (initialized.booleanValue()) {
            return mcpStatelessServerTransportProvider;
        }
        this.initialize();
        return mcpStatelessServerTransportProvider;
    }

    public McpStatelessAsyncServer getMcpStatelessAsyncServerInstance() {
        if (initialized.booleanValue()) {
            return mcpStatelessAsyncServer;
        }
        this.initialize();
        return mcpStatelessAsyncServer;
    }

    public void autoLoadAllMcpTools(ActionListener<Boolean> listener) {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener restoreListener = ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore());
            ActionListener searchListener = ActionListener.wrap(r -> {
                r.forEach((key, value) -> {
                    Long previousVersion = IN_MEMORY_MCP_TOOLS.putIfAbsent((String)key, (Long)value.v2());
                    if (previousVersion == null) {
                        this.getMcpStatelessAsyncServerInstance().addTool(this.mcpToolsHelper.createToolSpecification((McpToolBaseInput)value.v1())).doOnError(x -> {
                            IN_MEMORY_MCP_TOOLS.remove(key);
                            log.error("Failed to auto load tool: {}", (Object)((McpToolRegisterInput)value.v1()).getName(), x);
                        }).subscribe();
                    } else if (previousVersion < (Long)value.v2()) {
                        this.getMcpStatelessAsyncServerInstance().removeTool(key).onErrorResume(e -> {
                            log.warn("Failed to remove old tool version: {}", key, e);
                            return Mono.empty();
                        }).then(this.getMcpStatelessAsyncServerInstance().addTool(this.mcpToolsHelper.createToolSpecification((McpToolBaseInput)value.v1()))).doOnSuccess(x -> {
                            IN_MEMORY_MCP_TOOLS.put((String)key, (Long)value.v2());
                            log.info("Successfully updated tool: {} to version: {}", key, value.v2());
                        }).doOnError(x -> log.error("Failed to update tool: {} to version: {}", (Object)((McpToolRegisterInput)value.v1()).getName(), value.v2(), x)).subscribe();
                    }
                });
                this.startSyncMcpToolsJob();
                restoreListener.onResponse((Object)true);
            }, e -> {
                log.error("Failed to auto load all MCP tools to MCP server", (Throwable)e);
                restoreListener.onFailure(e);
            });
            this.mcpToolsHelper.searchAllToolsWithVersion((ActionListener<Map<String, Tuple<McpToolRegisterInput, Long>>>)searchListener);
        }
        catch (Exception e2) {
            log.error("Failed to auto load all MCP tools to MCP server", (Throwable)e2);
            listener.onFailure(e2);
        }
    }

    public void startSyncMcpToolsJob() {
        ActionListener listener = ActionListener.wrap(r -> log.debug("Auto reload mcp tools schedule job run successfully!"), e -> log.error(e.getMessage(), (Throwable)e));
        this.threadPool.schedule(() -> this.autoLoadAllMcpTools((ActionListener<Boolean>)listener), TimeValue.timeValueSeconds((long)10L), "opensearch_mcp_tools_sync");
    }

    static {
        initialized = false;
    }
}

