/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.datasource;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.provenance.ObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.PrimitiveProvenance;
import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import com.oracle.labs.mlrg.olcut.provenance.ProvenanceUtil;
import com.oracle.labs.mlrg.olcut.provenance.impl.SkeletalConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.DateTimeProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.EnumProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.HashProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.StringProvenance;
import com.oracle.labs.mlrg.olcut.util.IOUtil;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import org.tribuo.ConfigurableDataSource;
import org.tribuo.Example;
import org.tribuo.Feature;
import org.tribuo.Output;
import org.tribuo.OutputFactory;
import org.tribuo.impl.ArrayExample;
import org.tribuo.provenance.DataSourceProvenance;

public final class IDXDataSource<T extends Output<T>>
implements ConfigurableDataSource<T> {
    private static final Logger logger = Logger.getLogger(IDXDataSource.class.getName());
    @Config(mandatory=true, description="Path to load the features from.")
    private Path featuresPath;
    @Config(mandatory=true, description="Path to load the features from.")
    private Path outputPath;
    @Config(mandatory=true, description="The output factory to use.")
    private OutputFactory<T> outputFactory;
    private final ArrayList<Example<T>> data = new ArrayList();
    private IDXType dataType;
    private IDXDataSourceProvenance provenance;

    private IDXDataSource() {
    }

    public IDXDataSource(Path featuresPath, Path outputPath, OutputFactory<T> outputFactory) throws IOException {
        this.outputFactory = outputFactory;
        this.featuresPath = featuresPath;
        this.outputPath = outputPath;
        this.read();
    }

    public void postConfig() throws IOException {
        this.read();
    }

    public String toString() {
        return "IDXDataSource(featuresPath=" + this.featuresPath.toString() + ",outputPath=" + this.outputPath.toString() + ",featureType=" + (Object)((Object)this.dataType) + ")";
    }

    @Override
    public OutputFactory<T> getOutputFactory() {
        return this.outputFactory;
    }

    public synchronized DataSourceProvenance getProvenance() {
        if (this.provenance == null) {
            this.provenance = this.cacheProvenance();
        }
        return this.provenance;
    }

    private IDXDataSourceProvenance cacheProvenance() {
        return new IDXDataSourceProvenance(this);
    }

    private void read() throws IOException {
        IDXData features = IDXDataSource.readData(this.featuresPath);
        IDXData outputs = IDXDataSource.readData(this.outputPath);
        this.dataType = features.dataType;
        if (features.shape[0] != outputs.shape[0]) {
            throw new IllegalStateException("Features and outputs have different numbers of examples, feature shape = " + Arrays.toString(features.shape) + ", output shape = " + Arrays.toString(outputs.shape));
        }
        int numFeatures = 1;
        for (int i = 1; i < features.shape.length; ++i) {
            numFeatures *= features.shape[i];
        }
        int numOutputs = 1;
        for (int i = 1; i < outputs.shape.length; ++i) {
            numOutputs *= outputs.shape[i];
        }
        String[] featureNames = new String[numFeatures];
        int width = ("" + numFeatures).length();
        String formatString = "%0" + width + "d";
        for (int i = 0; i < numFeatures; ++i) {
            featureNames[i] = String.format(formatString, i);
        }
        ArrayList<Feature> buffer = new ArrayList<Feature>();
        int featureCounter = 0;
        int outputCounter = 0;
        StringBuilder outputBuilder = new StringBuilder();
        for (int i = 0; i < features.data.length; ++i) {
            double curValue = features.data[i];
            if (curValue != 0.0) {
                buffer.add(new Feature(featureNames[featureCounter], curValue));
            }
            if (++featureCounter != numFeatures) continue;
            outputBuilder.setLength(0);
            block8: for (int j = 0; j < numOutputs; ++j) {
                if (j != 0) {
                    outputBuilder.append(',');
                }
                switch (outputs.dataType) {
                    case BYTE: 
                    case UBYTE: 
                    case SHORT: 
                    case INT: {
                        outputBuilder.append((int)outputs.data[j + outputCounter]);
                        continue block8;
                    }
                    case FLOAT: 
                    case DOUBLE: {
                        outputBuilder.append(outputs.data[j + outputCounter]);
                    }
                }
            }
            outputCounter += numOutputs;
            T output = this.outputFactory.generateOutput(outputBuilder.toString());
            ArrayExample<T> example = new ArrayExample<T>(output);
            ((Example)example).addAll(buffer);
            this.data.add(example);
            buffer.clear();
            featureCounter = 0;
        }
        if (featureCounter != 0) {
            throw new IllegalStateException("Failed to process all the features, missing " + (numFeatures - featureCounter) + " values");
        }
    }

    static IDXData readData(Path path) throws IOException {
        InputStream inputStream = IOUtil.getInputStreamForLocation((String)path.toString());
        if (inputStream == null) {
            throw new FileNotFoundException("Failed to load from path - " + path);
        }
        try (DataInputStream stream = new DataInputStream(inputStream);){
            short magicNumber = stream.readShort();
            if (magicNumber != 0) {
                throw new IllegalStateException("Invalid IDX file, magic number was not zero. Found " + magicNumber);
            }
            byte dataTypeByte = stream.readByte();
            IDXType dataType = IDXType.convert(dataTypeByte);
            int numDimensions = stream.readByte();
            if (numDimensions < 1) {
                throw new IllegalStateException("Invalid number of dimensions, found " + numDimensions);
            }
            int[] shape = new int[numDimensions];
            int size = 1;
            for (int i = 0; i < numDimensions; ++i) {
                shape[i] = stream.readInt();
                if (shape[i] < 1) {
                    throw new IllegalStateException("Invalid shape, found " + Arrays.toString(shape));
                }
                size *= shape[i];
            }
            double[] data = new double[size];
            try {
                block22: for (int i = 0; i < size; ++i) {
                    switch (dataType) {
                        case BYTE: {
                            data[i] = stream.readByte();
                            continue block22;
                        }
                        case UBYTE: {
                            data[i] = stream.readUnsignedByte();
                            continue block22;
                        }
                        case SHORT: {
                            data[i] = stream.readShort();
                            continue block22;
                        }
                        case INT: {
                            data[i] = stream.readInt();
                            continue block22;
                        }
                        case FLOAT: {
                            data[i] = stream.readFloat();
                            continue block22;
                        }
                        case DOUBLE: {
                            data[i] = stream.readDouble();
                        }
                    }
                }
            }
            catch (EOFException e) {
                throw new IllegalStateException("Too little data in the file, expected to find " + size + " elements");
            }
            try {
                byte unexpectedByte = stream.readByte();
                throw new IllegalStateException("Too much data in the file");
            }
            catch (EOFException eOFException) {
                IDXData iDXData = new IDXData(dataType, shape, data);
                return iDXData;
            }
        }
    }

    public int size() {
        return this.data.size();
    }

    public IDXType getDataType() {
        return this.dataType;
    }

    @Override
    public Iterator<Example<T>> iterator() {
        return this.data.iterator();
    }

    public static final class IDXDataSourceProvenance
    extends SkeletalConfiguredObjectProvenance
    implements DataSourceProvenance {
        private static final long serialVersionUID = 1L;
        public static final String OUTPUT_FILE_MODIFIED_TIME = "output-file-modified-time";
        public static final String FEATURES_FILE_MODIFIED_TIME = "features-file-modified-time";
        public static final String FEATURES_RESOURCE_HASH = "features-resource-hash";
        public static final String OUTPUT_RESOURCE_HASH = "output-resource-hash";
        public static final String FEATURE_TYPE = "idx-feature-type";
        private final DateTimeProvenance featuresFileModifiedTime;
        private final DateTimeProvenance outputFileModifiedTime;
        private final DateTimeProvenance dataSourceCreationTime;
        private final HashProvenance featuresSHA256Hash;
        private final HashProvenance outputSHA256Hash;
        private final EnumProvenance<IDXType> featureType;

        <T extends Output<T>> IDXDataSourceProvenance(IDXDataSource<T> host) {
            super(host, "DataSource");
            this.outputFileModifiedTime = new DateTimeProvenance(OUTPUT_FILE_MODIFIED_TIME, OffsetDateTime.ofInstant(Instant.ofEpochMilli(((IDXDataSource)host).outputPath.toFile().lastModified()), ZoneId.systemDefault()));
            this.featuresFileModifiedTime = new DateTimeProvenance(FEATURES_FILE_MODIFIED_TIME, OffsetDateTime.ofInstant(Instant.ofEpochMilli(((IDXDataSource)host).featuresPath.toFile().lastModified()), ZoneId.systemDefault()));
            this.dataSourceCreationTime = new DateTimeProvenance("datasource-creation-time", OffsetDateTime.now());
            this.featuresSHA256Hash = new HashProvenance(DEFAULT_HASH_TYPE, FEATURES_RESOURCE_HASH, ProvenanceUtil.hashResource((ProvenanceUtil.HashType)DEFAULT_HASH_TYPE, (Path)((IDXDataSource)host).featuresPath));
            this.outputSHA256Hash = new HashProvenance(DEFAULT_HASH_TYPE, OUTPUT_RESOURCE_HASH, ProvenanceUtil.hashResource((ProvenanceUtil.HashType)DEFAULT_HASH_TYPE, (Path)((IDXDataSource)host).outputPath));
            this.featureType = new EnumProvenance(FEATURE_TYPE, (Enum)((IDXDataSource)host).dataType);
        }

        public IDXDataSourceProvenance(Map<String, Provenance> map) {
            this(IDXDataSourceProvenance.extractProvenanceInfo(map));
        }

        private IDXDataSourceProvenance(SkeletalConfiguredObjectProvenance.ExtractedInfo info) {
            super(info);
            this.featuresFileModifiedTime = (DateTimeProvenance)info.instanceValues.get(FEATURES_FILE_MODIFIED_TIME);
            this.outputFileModifiedTime = (DateTimeProvenance)info.instanceValues.get(OUTPUT_FILE_MODIFIED_TIME);
            this.dataSourceCreationTime = (DateTimeProvenance)info.instanceValues.get("datasource-creation-time");
            this.featuresSHA256Hash = (HashProvenance)info.instanceValues.get(FEATURES_RESOURCE_HASH);
            this.outputSHA256Hash = (HashProvenance)info.instanceValues.get(OUTPUT_RESOURCE_HASH);
            this.featureType = (EnumProvenance)info.instanceValues.get(FEATURE_TYPE);
        }

        protected static SkeletalConfiguredObjectProvenance.ExtractedInfo extractProvenanceInfo(Map<String, Provenance> map) {
            HashMap<String, Provenance> configuredParameters = new HashMap<String, Provenance>(map);
            String className = ((StringProvenance)ObjectProvenance.checkAndExtractProvenance(configuredParameters, (String)"class-name", StringProvenance.class, (String)IDXDataSourceProvenance.class.getSimpleName())).getValue();
            String hostTypeStringName = ((StringProvenance)ObjectProvenance.checkAndExtractProvenance(configuredParameters, (String)"host-short-name", StringProvenance.class, (String)IDXDataSourceProvenance.class.getSimpleName())).getValue();
            HashMap<String, Provenance> instanceParameters = new HashMap<String, Provenance>();
            instanceParameters.put(FEATURES_FILE_MODIFIED_TIME, ObjectProvenance.checkAndExtractProvenance(configuredParameters, (String)FEATURES_FILE_MODIFIED_TIME, DateTimeProvenance.class, (String)IDXDataSourceProvenance.class.getSimpleName()));
            instanceParameters.put(OUTPUT_FILE_MODIFIED_TIME, ObjectProvenance.checkAndExtractProvenance(configuredParameters, (String)OUTPUT_FILE_MODIFIED_TIME, DateTimeProvenance.class, (String)IDXDataSourceProvenance.class.getSimpleName()));
            instanceParameters.put("datasource-creation-time", ObjectProvenance.checkAndExtractProvenance(configuredParameters, (String)"datasource-creation-time", DateTimeProvenance.class, (String)IDXDataSourceProvenance.class.getSimpleName()));
            instanceParameters.put(FEATURES_RESOURCE_HASH, ObjectProvenance.checkAndExtractProvenance(configuredParameters, (String)FEATURES_RESOURCE_HASH, HashProvenance.class, (String)IDXDataSourceProvenance.class.getSimpleName()));
            instanceParameters.put(OUTPUT_RESOURCE_HASH, ObjectProvenance.checkAndExtractProvenance(configuredParameters, (String)OUTPUT_RESOURCE_HASH, HashProvenance.class, (String)IDXDataSourceProvenance.class.getSimpleName()));
            instanceParameters.put(FEATURE_TYPE, ObjectProvenance.checkAndExtractProvenance(configuredParameters, (String)FEATURE_TYPE, EnumProvenance.class, (String)IDXDataSourceProvenance.class.getSimpleName()));
            return new SkeletalConfiguredObjectProvenance.ExtractedInfo(className, hostTypeStringName, configuredParameters, instanceParameters);
        }

        public Map<String, PrimitiveProvenance<?>> getInstanceValues() {
            Map map = super.getInstanceValues();
            map.put(this.featuresFileModifiedTime.getKey(), this.featuresFileModifiedTime);
            map.put(this.outputFileModifiedTime.getKey(), this.outputFileModifiedTime);
            map.put(this.dataSourceCreationTime.getKey(), this.dataSourceCreationTime);
            map.put(this.featuresSHA256Hash.getKey(), this.featuresSHA256Hash);
            map.put(this.outputSHA256Hash.getKey(), this.outputSHA256Hash);
            map.put(this.featureType.getKey(), this.featureType);
            return map;
        }
    }

    public static class IDXData {
        final IDXType dataType;
        final int[] shape;
        final double[] data;

        IDXData(IDXType dataType, int[] shape, double[] data) {
            this.dataType = dataType;
            this.shape = shape;
            this.data = data;
        }

        public static IDXData createIDXData(IDXType dataType, int[] shape, double[] data) {
            int i;
            int[] shapeCopy = Arrays.copyOf(shape, shape.length);
            double[] dataCopy = Arrays.copyOf(data, data.length);
            if (shape.length > 128) {
                throw new IllegalArgumentException("Must have fewer than 128 dimensions");
            }
            int numElements = 1;
            for (i = 0; i < shapeCopy.length; ++i) {
                numElements *= shapeCopy[i];
                if (shapeCopy[i] >= 1) continue;
                throw new IllegalArgumentException("Invalid shape, all elements must be positive, found " + Arrays.toString(shapeCopy));
            }
            if (numElements != dataCopy.length) {
                throw new IllegalArgumentException("Incorrect number of elements, expected " + numElements + ", found " + dataCopy.length);
            }
            if (dataType != IDXType.DOUBLE) {
                block8: for (i = 0; i < dataCopy.length; ++i) {
                    switch (dataType) {
                        case UBYTE: {
                            int tmpU = 0xFF & (int)dataCopy[i];
                            if (dataCopy[i] == (double)tmpU) continue block8;
                            throw new IllegalArgumentException("Invalid value at idx " + i + ", could not be converted to unsigned byte");
                        }
                        case BYTE: {
                            byte tmpB = (byte)dataCopy[i];
                            if (dataCopy[i] == (double)tmpB) continue block8;
                            throw new IllegalArgumentException("Invalid value at idx " + i + ", could not be converted to byte");
                        }
                        case SHORT: {
                            short tmpS = (short)dataCopy[i];
                            if (dataCopy[i] == (double)tmpS) continue block8;
                            throw new IllegalArgumentException("Invalid value at idx " + i + ", could not be converted to short");
                        }
                        case INT: {
                            int tmpI = (int)dataCopy[i];
                            if (dataCopy[i] == (double)tmpI) continue block8;
                            throw new IllegalArgumentException("Invalid value at idx " + i + ", could not be converted to int");
                        }
                        case FLOAT: {
                            float tmpF = (float)dataCopy[i];
                            if (dataCopy[i] == (double)tmpF) continue block8;
                            throw new IllegalArgumentException("Invalid value at idx " + i + ", could not be converted to float");
                        }
                    }
                }
            }
            return new IDXData(dataType, shape, data);
        }

        public void save(Path outputPath, boolean gzip) throws IOException {
            try (DataOutputStream ds = IDXData.makeStream(outputPath, gzip);){
                int i;
                ds.writeShort(0);
                ds.writeByte(this.dataType.value);
                ds.writeByte(this.shape.length);
                for (i = 0; i < this.shape.length; ++i) {
                    ds.writeInt(this.shape[i]);
                }
                block18: for (i = 0; i < this.data.length; ++i) {
                    switch (this.dataType) {
                        case UBYTE: {
                            ds.writeByte(0xFF & (int)this.data[i]);
                            continue block18;
                        }
                        case BYTE: {
                            ds.writeByte((byte)this.data[i]);
                            continue block18;
                        }
                        case SHORT: {
                            ds.writeShort((short)this.data[i]);
                            continue block18;
                        }
                        case INT: {
                            ds.writeInt((int)this.data[i]);
                            continue block18;
                        }
                        case FLOAT: {
                            ds.writeFloat((float)this.data[i]);
                            continue block18;
                        }
                        case DOUBLE: {
                            ds.writeDouble(this.data[i]);
                        }
                    }
                }
            }
        }

        private static DataOutputStream makeStream(Path outputPath, boolean gzip) throws IOException {
            OutputStream stream = gzip ? new GZIPOutputStream(new FileOutputStream(outputPath.toFile())) : new FileOutputStream(outputPath.toFile());
            return new DataOutputStream(new BufferedOutputStream(stream));
        }
    }

    public static enum IDXType {
        UBYTE(8),
        BYTE(9),
        SHORT(11),
        INT(12),
        FLOAT(13),
        DOUBLE(14);

        public final byte value;

        private IDXType(byte value) {
            this.value = value;
        }

        public static IDXType convert(byte input) {
            for (IDXType f : IDXType.values()) {
                if (f.value != input) continue;
                return f;
            }
            throw new IllegalArgumentException("Invalid byte found - " + input);
        }
    }
}

