/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cloud.gce;

import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.lifecycle.AbstractLifecycleComponent;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.secure_sm.AccessController;

public class GceMetadataService
extends AbstractLifecycleComponent {
    private static final Logger logger = LogManager.getLogger(GceMetadataService.class);
    public static final Setting<String> GCE_HOST = new Setting("cloud.gce.host", "http://metadata.google.internal", Function.identity(), new Setting.Property[]{Setting.Property.NodeScope});
    private final Settings settings;
    private HttpTransport gceHttpTransport;

    public GceMetadataService(Settings settings) {
        this.settings = settings;
    }

    protected synchronized HttpTransport getGceHttpTransport() throws GeneralSecurityException, IOException {
        if (this.gceHttpTransport == null) {
            this.gceHttpTransport = GoogleNetHttpTransport.newTrustedTransport();
        }
        return this.gceHttpTransport;
    }

    public String metadata(String metadataPath) throws IOException, URISyntaxException {
        URI urlMetadataNetwork = new URI((String)GCE_HOST.get(this.settings)).resolve("/computeMetadata/v1/instance/").resolve(metadataPath);
        logger.debug("get metadata from [{}]", (Object)urlMetadataNetwork);
        try {
            HttpHeaders headers = (HttpHeaders)AccessController.doPrivileged(HttpHeaders::new);
            GenericUrl genericUrl = (GenericUrl)AccessController.doPrivileged(() -> new GenericUrl(urlMetadataNetwork));
            headers.put("Metadata-Flavor", (Object)"Google");
            HttpResponse response = (HttpResponse)AccessController.doPrivilegedChecked(() -> this.getGceHttpTransport().createRequestFactory().buildGetRequest(genericUrl).setHeaders(headers).execute());
            String metadata = response.parseAsString();
            logger.debug("metadata found [{}]", (Object)metadata);
            return metadata;
        }
        catch (Exception e) {
            throw new IOException("failed to fetch metadata from [" + String.valueOf(urlMetadataNetwork) + "]", e);
        }
    }

    protected void doStart() {
    }

    protected void doStop() {
        if (this.gceHttpTransport != null) {
            try {
                this.gceHttpTransport.shutdown();
            }
            catch (IOException e) {
                logger.warn("unable to shutdown GCE Http Transport", (Throwable)e);
            }
            this.gceHttpTransport = null;
        }
    }

    protected void doClose() {
    }
}

