"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiControlBar", {
  enumerable: true,
  get: function get() {
    return _control_bar.EuiControlBar;
  }
});
exports.OuiControlBar = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _classnames = _interopRequireDefault(require("classnames"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _accessibility = require("../accessibility");
var _breadcrumbs = require("../breadcrumbs");
var _button = require("../button");
var _i18n = require("../i18n");
var _icon = require("../icon");
var _portal = require("../portal");
var _control_bar = require("../../eui_components/control_bar/control_bar");
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != _typeof(e) && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) { "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); } return f; })(e, t); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _createSuper(t) { var r = _isNativeReflectConstruct(); return function () { var e, o = (0, _getPrototypeOf2.default)(t); if (r) { var s = (0, _getPrototypeOf2.default)(this).constructor; e = Reflect.construct(o, arguments, s); } else e = o.apply(this, arguments); return (0, _possibleConstructorReturn2.default)(this, e); }; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); } /*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */ /*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Extends OuiButton excluding `size`. Requires `label` as the `children`.
 */
/**
 * Creates a `button` visually styles as a tab.
 * Requires `label` as the `children`.
 * `onClick` must be provided to handle the content swapping.
 */
/**
 * Extends OuiBreadcrumbs
 */
/**
 * Simple div controlling color and size text output.
 * Requires `label` as the `children`.
 */
/**
 * Custom props specific to the icon control type
 */
/**
 * Icon can extend OuiIcon
 * Had to omit `onClick` as it's a valid prop of SVGElement
 * Also omits `type` and `id` as these are also specific to icon control
 */
/**
 * Icon can extend OuiButtonIcon
 * Also omits `iconType` and `id` as these are also specific to icon control
 */
var OuiControlBar = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(OuiControlBar, _Component);
  var _super = _createSuper(OuiControlBar);
  function OuiControlBar() {
    var _this;
    (0, _classCallCheck2.default)(this, OuiControlBar);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "bar", null);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "state", {
      selectedTab: ''
    });
    return _this;
  }
  (0, _createClass2.default)(OuiControlBar, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      if (this.props.position === 'fixed') {
        var height = this.bar ? this.bar.clientHeight : -1;
        document.body.style.paddingBottom = "".concat(height, "px");
        if (this.props.bodyClassName) {
          document.body.classList.add(this.props.bodyClassName);
        }
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      document.body.style.paddingBottom = '';
      if (this.props.bodyClassName) {
        document.body.classList.remove(this.props.bodyClassName);
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;
      var _this$props = this.props,
        children = _this$props.children,
        className = _this$props.className,
        showContent = _this$props.showContent,
        controls = _this$props.controls,
        size = _this$props.size,
        leftOffset = _this$props.leftOffset,
        rightOffset = _this$props.rightOffset,
        maxHeight = _this$props.maxHeight,
        showOnMobile = _this$props.showOnMobile,
        style = _this$props.style,
        position = _this$props.position,
        bodyClassName = _this$props.bodyClassName,
        landmarkHeading = _this$props.landmarkHeading,
        rest = (0, _objectWithoutProperties2.default)(_this$props, ["children", "className", "showContent", "controls", "size", "leftOffset", "rightOffset", "maxHeight", "showOnMobile", "style", "position", "bodyClassName", "landmarkHeading"]);
      var styles = _objectSpread(_objectSpread({}, style), {}, {
        left: leftOffset,
        right: rightOffset,
        maxHeight: maxHeight
      });
      var classes = (0, _classnames.default)('ouiControlBar', className, {
        'ouiControlBar-isOpen': showContent,
        'ouiControlBar--large': size === 'l',
        'ouiControlBar--medium': size === 'm',
        'ouiControlBar--small': size === 's',
        'ouiControlBar--fixed': position === 'fixed',
        'ouiControlBar--absolute': position === 'absolute',
        'ouiControlBar--relative': position === 'relative',
        'ouiControlBar--showOnMobile': showOnMobile
      });
      var handleTabClick = function handleTabClick(control, e) {
        _this2.setState({
          selectedTab: control.id
        }, function () {
          control.onClick(e);
        });
      };
      var controlItem = function controlItem(control, index) {
        switch (control.controlType) {
          case 'button':
            {
              var controlType = control.controlType,
                id = control.id,
                _control$color = control.color,
                color = _control$color === void 0 ? 'ghost' : _control$color,
                label = control.label,
                _className = control.className,
                _rest = (0, _objectWithoutProperties2.default)(control, ["controlType", "id", "color", "label", "className"]);
              return /*#__PURE__*/_react.default.createElement(_button.OuiButton, (0, _extends2.default)({
                key: id + index,
                className: (0, _classnames.default)('ouiControlBar__button', _className),
                color: color
              }, _rest, {
                size: "s"
              }), label);
            }
          case 'icon':
            {
              var _controlType = control.controlType,
                _id = control.id,
                iconType = control.iconType,
                _className2 = control.className,
                _control$color2 = control.color,
                _color = _control$color2 === void 0 ? 'ghost' : _control$color2,
                onClick = control.onClick,
                href = control.href,
                _rest2 = (0, _objectWithoutProperties2.default)(control, ["controlType", "id", "iconType", "className", "color", "onClick", "href"]);
              return onClick || href ? /*#__PURE__*/_react.default.createElement(_button.OuiButtonIcon, (0, _extends2.default)({
                key: _id + index,
                className: (0, _classnames.default)('ouiControlBar__buttonIcon', _className2),
                onClick: onClick,
                href: href,
                color: _color
              }, _rest2, {
                iconType: iconType
              })) : /*#__PURE__*/_react.default.createElement(_icon.OuiIcon, (0, _extends2.default)({
                key: _id + index,
                className: (0, _classnames.default)('ouiControlBar__icon', _className2),
                type: iconType,
                color: _color
              }, _rest2));
            }
          case 'divider':
            return /*#__PURE__*/_react.default.createElement("div", {
              key: control.controlType + index,
              className: "ouiControlBar__divider"
            });
          case 'spacer':
            return /*#__PURE__*/_react.default.createElement("div", {
              key: control.controlType + index,
              className: "ouiControlBar__spacer"
            });
          case 'text':
            {
              var _controlType2 = control.controlType,
                _id2 = control.id,
                text = control.text,
                _className3 = control.className,
                _rest3 = (0, _objectWithoutProperties2.default)(control, ["controlType", "id", "text", "className"]);
              return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
                key: _id2,
                className: (0, _classnames.default)('ouiControlBar__text', _className3)
              }, _rest3), text);
            }
          case 'tab':
            {
              var _controlType3 = control.controlType,
                _id3 = control.id,
                _label = control.label,
                _onClick = control.onClick,
                _className4 = control.className,
                _rest4 = (0, _objectWithoutProperties2.default)(control, ["controlType", "id", "label", "onClick", "className"]);
              var tabClasses = (0, _classnames.default)('ouiControlBar__tab', {
                'ouiControlBar__tab--active': showContent && _id3 === _this2.state.selectedTab
              }, _className4);
              return /*#__PURE__*/_react.default.createElement("button", (0, _extends2.default)({
                key: _id3 + index,
                className: tabClasses,
                onClick: function onClick(event) {
                  return handleTabClick(control, event);
                }
              }, _rest4), _label);
            }
          case 'breadcrumbs':
            {
              var _controlType4 = control.controlType,
                _id4 = control.id,
                _rest5 = (0, _objectWithoutProperties2.default)(control, ["controlType", "id"]);
              return /*#__PURE__*/_react.default.createElement(_breadcrumbs.OuiBreadcrumbs, (0, _extends2.default)({
                className: "ouiControlBar__breadcrumbs",
                key: control.id
              }, _rest5));
            }
        }
      };
      var controlBar = /*#__PURE__*/_react.default.createElement(_i18n.OuiI18n, {
        token: "ouiControlBar.screenReaderHeading",
        default: "Page level controls"
      }, function (screenReaderHeading) {
        return (
          /*#__PURE__*/
          // Though it would be better to use aria-labelledby than aria-label and not repeat the same string twice
          // A bug in voiceover won't list some landmarks in the rotor without an aria-label
          _react.default.createElement("section", (0, _extends2.default)({
            className: classes,
            "aria-label": landmarkHeading ? landmarkHeading : screenReaderHeading
          }, rest, {
            style: styles
          }), /*#__PURE__*/_react.default.createElement(_accessibility.OuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("h2", null, landmarkHeading ? landmarkHeading : screenReaderHeading)), /*#__PURE__*/_react.default.createElement("div", {
            className: "ouiControlBar__controls",
            ref: function ref(node) {
              _this2.bar = node;
            }
          }, controls.map(function (control, index) {
            return controlItem(control, index);
          })), _this2.props.showContent ? /*#__PURE__*/_react.default.createElement("div", {
            className: "ouiControlBar__content"
          }, children) : null)
        );
      });
      return position === 'fixed' ? /*#__PURE__*/_react.default.createElement(_portal.OuiPortal, null, controlBar, /*#__PURE__*/_react.default.createElement(_accessibility.OuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("p", {
        "aria-live": "assertive"
      }, landmarkHeading ? /*#__PURE__*/_react.default.createElement(_i18n.OuiI18n, {
        token: "ouiControlBar.customScreenReaderAnnouncement",
        default: "There is a new region landmark called {landmarkHeading} with page level controls at the end of the document.",
        values: {
          landmarkHeading: landmarkHeading
        }
      }) : /*#__PURE__*/_react.default.createElement(_i18n.OuiI18n, {
        token: "ouiControlBar.screenReaderAnnouncement",
        default: "There is a new region landmark with page level controls at the end of the document."
      })))) : controlBar;
    }
  }]);
  return OuiControlBar;
}(_react.Component);
/* OUI -> EUI Aliases: Build-Time */
exports.OuiControlBar = OuiControlBar;
(0, _defineProperty2.default)(OuiControlBar, "defaultProps", {
  leftOffset: 0,
  rightOffset: 0,
  position: 'fixed',
  size: 'l',
  showContent: false,
  showOnMobile: false
});
OuiControlBar.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  /**
       * Show or hide the content area containing the `children`
       */
  showContent: _propTypes.default.bool,
  /**
       * An array of controls, actions, and layout spacers to display.
       * Accepts `'button' | 'tab' | 'breadcrumbs' | 'text' | 'icon' | 'spacer' | 'divider'`
       */
  controls: _propTypes.default.arrayOf(_propTypes.default.shape({
    href: _propTypes.default.string,
    onClick: _propTypes.default.func,
    id: _propTypes.default.string,
    label: _propTypes.default.oneOfType([_propTypes.default.node.isRequired, _propTypes.default.node]),
    buttonRef: _propTypes.default.any,
    controlType: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.oneOf(["button"]).isRequired, _propTypes.default.oneOfType([_propTypes.default.oneOf(["breadcrumbs"]).isRequired, _propTypes.default.oneOf(["tab"]).isRequired]).isRequired]).isRequired, _propTypes.default.oneOf(["text"]).isRequired]).isRequired, _propTypes.default.oneOf(["icon"]).isRequired]).isRequired, _propTypes.default.oneOf(["divider"]).isRequired]).isRequired, _propTypes.default.oneOf(["spacer"]).isRequired]).isRequired,
    className: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.string]),
    "aria-label": _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.string]),
    "data-test-subj": _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.string]),
    /**
       * Hides extra (above the max) breadcrumbs under a collapsed item as the window gets smaller.
       * Pass a custom #OuiBreadcrumbResponsiveMaxCount object to change the number of breadcrumbs to show at the particular breakpoints.
       * Omitting or passing a `0` value will show all breadcrumbs.
       *
       * Pass `false` to turn this behavior off.
       *
       * Default: `{ xs: 1, s: 2, m: 4 }`
       */
    responsive: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.any.isRequired]),
    /**
       * Forces all breadcrumbs to single line and
       * truncates each breadcrumb to a particular width,
       * except for the last item
       */
    truncate: _propTypes.default.bool,
    /**
       * Collapses the inner items past the maximum set here
       * into a single ellipses item
       */
    max: _propTypes.default.oneOfType([_propTypes.default.number.isRequired, _propTypes.default.oneOf([null])]),
    /**
       * The array of individual #OuiBreadcrumb items
       */
    breadcrumbs: _propTypes.default.arrayOf(_propTypes.default.shape({
      className: _propTypes.default.string,
      "aria-label": _propTypes.default.string,
      "data-test-subj": _propTypes.default.string,
      /**
         * Visible label of the breadcrumb
         */
      text: _propTypes.default.node.isRequired,
      href: _propTypes.default.string,
      onClick: _propTypes.default.func,
      /**
         * Force a max-width on the breadcrumb text
         */
      truncate: _propTypes.default.bool
    }).isRequired),
    text: _propTypes.default.node,
    iconType: _propTypes.default.string
  }).isRequired).isRequired,
  /**
       * The default height of the content area.
       */
  size: _propTypes.default.oneOf(["s", "m", "l"]),
  /**
       * Customize the max height.
       * Best when used with `size=l` as this will ensure the actual height equals the max height set.
       */
  maxHeight: _propTypes.default.oneOfType([_propTypes.default.number.isRequired, _propTypes.default.string.isRequired]),
  /**
       * Set the offset from the left side of the screen.
       */
  leftOffset: _propTypes.default.oneOfType([_propTypes.default.number.isRequired, _propTypes.default.string.isRequired]),
  /**
       * Set the offset from the left side of the screen.
       */
  rightOffset: _propTypes.default.oneOfType([_propTypes.default.number.isRequired, _propTypes.default.string.isRequired]),
  /**
       * The control bar is hidden on mobile by default. Use the `showOnMobile` prop to force it's display on mobile screens.
       * You'll need to ensure that the content you place into the bar renders as expected on mobile.
       */
  showOnMobile: _propTypes.default.bool,
  /**
       * By default OuiControlBar will live in a portal, fixed position to the browser window.
       * Change the position of the bar to live inside a container and be positioned against its parent.
       */
  position: _propTypes.default.oneOf(["fixed", "relative", "absolute"]),
  /**
       * Optional class applied to the body used when `position = fixed`
       */
  bodyClassName: _propTypes.default.string,
  /**
       * Customize the screen reader heading that helps users find this control. Default is "Page level controls".
       */
  landmarkHeading: _propTypes.default.string
};
/* OUI -> EUI Aliases: Build-Time */