/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.pipeline;

import java.util.Collections;
import java.util.List;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchPhaseContext;
import org.opensearch.action.search.SearchPhaseResults;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.common.Nullable;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.search.SearchPhaseResult;
import org.opensearch.search.pipeline.PipelineProcessingContext;
import org.opensearch.search.pipeline.PipelinedRequest;
import org.opensearch.search.pipeline.Processor;
import org.opensearch.search.pipeline.SearchPhaseResultsProcessor;
import org.opensearch.search.pipeline.SearchPipelineProcessingException;
import org.opensearch.search.pipeline.SearchRequestProcessor;
import org.opensearch.search.pipeline.SearchResponseProcessor;
import org.opensearch.search.pipeline.TrackingSearchRequestProcessorWrapper;
import org.opensearch.search.pipeline.TrackingSearchResponseProcessorWrapper;

class Pipeline {
    public static final String REQUEST_PROCESSORS_KEY = "request_processors";
    public static final String RESPONSE_PROCESSORS_KEY = "response_processors";
    public static final String PHASE_PROCESSORS_KEY = "phase_results_processors";
    private static final Logger logger = LogManager.getLogger(Pipeline.class);
    private final String id;
    private final String description;
    private final Integer version;
    private final List<SearchRequestProcessor> searchRequestProcessors;
    private final List<SearchResponseProcessor> searchResponseProcessors;
    private final List<SearchPhaseResultsProcessor> searchPhaseResultsProcessors;
    private final NamedWriteableRegistry namedWriteableRegistry;
    private final LongSupplier relativeTimeSupplier;
    static final Pipeline NO_OP_PIPELINE = new Pipeline("_none", "Pipeline that does not transform anything", 0, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, () -> 0L);

    Pipeline(String id, @Nullable String description, @Nullable Integer version, List<SearchRequestProcessor> requestProcessors, List<SearchResponseProcessor> responseProcessors, List<SearchPhaseResultsProcessor> phaseResultsProcessors, NamedWriteableRegistry namedWriteableRegistry, LongSupplier relativeTimeSupplier) {
        this.id = id;
        this.description = description;
        this.version = version;
        this.searchRequestProcessors = Collections.unmodifiableList(requestProcessors);
        this.searchResponseProcessors = Collections.unmodifiableList(responseProcessors);
        this.searchPhaseResultsProcessors = Collections.unmodifiableList(phaseResultsProcessors);
        this.namedWriteableRegistry = namedWriteableRegistry;
        this.relativeTimeSupplier = relativeTimeSupplier;
    }

    String getId() {
        return this.id;
    }

    String getDescription() {
        return this.description;
    }

    Integer getVersion() {
        return this.version;
    }

    List<SearchRequestProcessor> getSearchRequestProcessors() {
        return this.searchRequestProcessors;
    }

    List<SearchResponseProcessor> getSearchResponseProcessors() {
        return this.searchResponseProcessors;
    }

    List<SearchPhaseResultsProcessor> getSearchPhaseResultsProcessors() {
        return this.searchPhaseResultsProcessors;
    }

    protected void beforeTransformRequest() {
    }

    protected void afterTransformRequest(long timeInNanos) {
    }

    protected void onTransformRequestFailure() {
    }

    protected void beforeRequestProcessor(Processor processor) {
    }

    protected void afterRequestProcessor(Processor processor, long timeInNanos) {
    }

    protected void onRequestProcessorFailed(Processor processor) {
    }

    protected void beforeTransformResponse() {
    }

    protected void afterTransformResponse(long timeInNanos) {
    }

    protected void onTransformResponseFailure() {
    }

    protected void beforeResponseProcessor(Processor processor) {
    }

    protected void afterResponseProcessor(Processor processor, long timeInNanos) {
    }

    protected void onResponseProcessorFailed(Processor processor) {
    }

    void transformRequest(PipelinedRequest pipelinedRequest, ActionListener<SearchRequest> requestListener) throws SearchPipelineProcessingException {
        ActionListener finalListener;
        if (this.searchRequestProcessors.isEmpty()) {
            requestListener.onResponse((Object)pipelinedRequest);
            return;
        }
        PipelineProcessingContext requestContext = pipelinedRequest.getPipelineProcessingContext();
        ActionListener currentListener = finalListener = this.getTerminalSearchRequestActionListener(requestListener);
        for (int i = this.searchRequestProcessors.size() - 1; i >= 0; --i) {
            ActionListener nextListener = currentListener;
            SearchRequestProcessor processor = pipelinedRequest.source().verbosePipeline() != false ? new TrackingSearchRequestProcessorWrapper(this.searchRequestProcessors.get(i)) : this.searchRequestProcessors.get(i);
            currentListener = ActionListener.wrap(r -> {
                long start = this.relativeTimeSupplier.getAsLong();
                this.beforeRequestProcessor(processor);
                processor.processRequestAsync((SearchRequest)r, requestContext, (ActionListener<SearchRequest>)ActionListener.wrap(rr -> {
                    long took = this.relativeTimeSupplier.getAsLong() - start;
                    this.afterRequestProcessor(processor, took);
                    nextListener.onResponse(rr);
                }, e -> {
                    long took = this.relativeTimeSupplier.getAsLong() - start;
                    this.afterRequestProcessor(processor, took);
                    this.onRequestProcessorFailed(processor);
                    if (processor.isIgnoreFailure() || r.source().verbosePipeline().booleanValue()) {
                        logger.warn("The exception from request processor [" + processor.getType() + "] in the search pipeline [" + this.id + "] was ignored", (Throwable)e);
                        nextListener.onResponse(r);
                    } else {
                        nextListener.onFailure((Exception)((Object)new SearchPipelineProcessingException((Exception)e)));
                    }
                }));
            }, arg_0 -> finalListener.onFailure(arg_0));
        }
        this.beforeTransformRequest();
        currentListener.onResponse((Object)pipelinedRequest);
    }

    private ActionListener<SearchRequest> getTerminalSearchRequestActionListener(ActionListener<SearchRequest> requestListener) {
        long pipelineStart = this.relativeTimeSupplier.getAsLong();
        return ActionListener.wrap(r -> {
            long took = this.relativeTimeSupplier.getAsLong() - pipelineStart;
            this.afterTransformRequest(took);
            requestListener.onResponse(r);
        }, e -> {
            long took = this.relativeTimeSupplier.getAsLong() - pipelineStart;
            this.afterTransformRequest(took);
            this.onTransformRequestFailure();
            requestListener.onFailure((Exception)((Object)new SearchPipelineProcessingException((Exception)e)));
        });
    }

    ActionListener<SearchResponse> transformResponseListener(PipelinedRequest pipelinedRequest, ActionListener<SearchResponse> responseListener) {
        if (this.searchResponseProcessors.isEmpty()) {
            return responseListener;
        }
        PipelineProcessingContext requestContext = pipelinedRequest.getPipelineProcessingContext();
        long[] pipelineStart = new long[1];
        ActionListener originalListener = responseListener;
        ActionListener finalListener = responseListener = ActionListener.wrap(r -> {
            long took = this.relativeTimeSupplier.getAsLong() - pipelineStart[0];
            this.afterTransformResponse(took);
            originalListener.onResponse(r);
        }, e -> {
            long took = this.relativeTimeSupplier.getAsLong() - pipelineStart[0];
            this.afterTransformResponse(took);
            this.onTransformResponseFailure();
            originalListener.onFailure(e);
        });
        for (int i = this.searchResponseProcessors.size() - 1; i >= 0; --i) {
            ActionListener currentFinalListener = responseListener;
            SearchResponseProcessor processor = pipelinedRequest.source().verbosePipeline() != false ? new TrackingSearchResponseProcessorWrapper(this.searchResponseProcessors.get(i)) : this.searchResponseProcessors.get(i);
            responseListener = ActionListener.wrap(r -> {
                this.beforeResponseProcessor(processor);
                long start = this.relativeTimeSupplier.getAsLong();
                processor.processResponseAsync(pipelinedRequest, (SearchResponse)r, requestContext, (ActionListener<SearchResponse>)ActionListener.wrap(rr -> {
                    long took = this.relativeTimeSupplier.getAsLong() - start;
                    this.afterResponseProcessor(processor, took);
                    currentFinalListener.onResponse(rr);
                }, e -> {
                    this.onResponseProcessorFailed(processor);
                    long took = this.relativeTimeSupplier.getAsLong() - start;
                    this.afterResponseProcessor(processor, took);
                    if (processor.isIgnoreFailure() || pipelinedRequest.source().verbosePipeline().booleanValue()) {
                        logger.warn("The exception from response processor [" + processor.getType() + "] in the search pipeline [" + this.id + "] was ignored", (Throwable)e);
                        currentFinalListener.onResponse(r);
                    } else {
                        currentFinalListener.onFailure((Exception)((Object)new SearchPipelineProcessingException((Exception)e)));
                    }
                }));
            }, arg_0 -> ((ActionListener)finalListener).onFailure(arg_0));
        }
        ActionListener chainListener = responseListener;
        return ActionListener.wrap(r -> {
            this.beforeTransformResponse();
            pipelineStart[0] = this.relativeTimeSupplier.getAsLong();
            chainListener.onResponse(r);
        }, arg_0 -> ((ActionListener)originalListener).onFailure(arg_0));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    <Result extends SearchPhaseResult> void runSearchPhaseResultsTransformer(SearchPhaseResults<Result> searchPhaseResult, SearchPhaseContext context, String currentPhase, String nextPhase, PipelineProcessingContext requestContext) throws SearchPipelineProcessingException {
        try {
            for (SearchPhaseResultsProcessor searchPhaseResultsProcessor : this.searchPhaseResultsProcessors) {
                if (!currentPhase.equals(searchPhaseResultsProcessor.getBeforePhase().getName()) || !nextPhase.equals(searchPhaseResultsProcessor.getAfterPhase().getName())) continue;
                try {
                    searchPhaseResultsProcessor.process(searchPhaseResult, context, requestContext);
                }
                catch (Exception e) {
                    if (!searchPhaseResultsProcessor.isIgnoreFailure()) throw e;
                    logger.warn("The exception from search phase results processor [" + searchPhaseResultsProcessor.getType() + "] in the search pipeline [" + this.id + "] was ignored", (Throwable)e);
                    continue;
                    return;
                }
            }
        }
        catch (RuntimeException e) {
            throw new SearchPipelineProcessingException(e);
        }
    }

    public boolean isNoOp() {
        return this.searchRequestProcessors.isEmpty() && this.searchPhaseResultsProcessors.isEmpty() && this.searchResponseProcessors.isEmpty();
    }
}

