/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rule.rest;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.rule.action.GetRuleAction;
import org.opensearch.rule.action.GetRuleRequest;
import org.opensearch.rule.action.GetRuleResponse;
import org.opensearch.rule.autotagging.FeatureType;
import org.opensearch.transport.client.node.NodeClient;

@ExperimentalApi
public class RestGetRuleAction
extends BaseRestHandler {
    public static final String SEARCH_AFTER_STRING = "search_after";
    public static final String FEATURE_TYPE = "featureType";

    public String getName() {
        return "get_rule";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "_rules/{featureType}/"), new RestHandler.Route(RestRequest.Method.GET, "_rules/{featureType}/{id}"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        HashMap<String, HashSet<String>> attributeFilters = new HashMap<String, HashSet<String>>();
        if (!request.hasParam(FEATURE_TYPE)) {
            throw new IllegalArgumentException("Invalid route.");
        }
        FeatureType featureType = FeatureType.from((String)request.param(FEATURE_TYPE));
        List<String> attributeParams = request.params().keySet().stream().filter(key -> featureType.getAllowedAttributesRegistry().containsKey(key.split("\\.", 2)[0])).toList();
        for (String attributeName : attributeParams) {
            attributeFilters.put(attributeName, this.parseAttributeValues(request.param(attributeName), attributeName, featureType));
        }
        GetRuleRequest getRuleRequest = new GetRuleRequest(request.param("id"), attributeFilters, request.param(SEARCH_AFTER_STRING), featureType);
        return channel -> client.execute((ActionType)GetRuleAction.INSTANCE, (ActionRequest)getRuleRequest, this.getRuleResponse((RestChannel)channel));
    }

    private HashSet<String> parseAttributeValues(String attributeValues, String attributeName, FeatureType featureType) {
        int maxNumberOfValuesPerAttribute;
        String[] valuesArray = attributeValues.split(",");
        if (valuesArray.length > (maxNumberOfValuesPerAttribute = featureType.getMaxNumberOfValuesPerAttribute())) {
            throw new IllegalArgumentException("The attribute value length for " + attributeName + " exceeds the maximum allowed of " + maxNumberOfValuesPerAttribute);
        }
        for (String value : valuesArray) {
            if (value != null && !value.trim().isEmpty() && value.length() <= featureType.getMaxCharLengthPerAttributeValue()) continue;
            throw new IllegalArgumentException("Invalid attribute value for: " + attributeName + " : String cannot be empty or over " + featureType.getMaxCharLengthPerAttributeValue() + " characters.");
        }
        return new HashSet<String>(Arrays.asList(valuesArray));
    }

    private RestResponseListener<GetRuleResponse> getRuleResponse(RestChannel channel) {
        return new RestResponseListener<GetRuleResponse>(this, channel){

            public RestResponse buildResponse(GetRuleResponse response) throws Exception {
                return new BytesRestResponse(RestStatus.OK, response.toXContent(this.channel.newBuilder(), ToXContent.EMPTY_PARAMS));
            }
        };
    }
}

