/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.model.schema;

import java.math.BigDecimal;
import java.util.Objects;
import org.apache.commons.lang3.BooleanUtils;
import org.openapitools.openapidiff.core.model.BackwardIncompatibleProp;
import org.openapitools.openapidiff.core.model.Changed;
import org.openapitools.openapidiff.core.model.DiffContext;
import org.openapitools.openapidiff.core.model.DiffResult;

public final class ChangedNumericRange
implements Changed {
    private final BigDecimal oldMinimumValue;
    private final BigDecimal newMinimumValue;
    private final BigDecimal oldMaximumValue;
    private final BigDecimal newMaximumValue;
    private final Boolean oldMinimumExclusiveValue;
    private final Boolean newMinimumExclusiveValue;
    private final Boolean oldMaximumExclusiveValue;
    private final Boolean newMaximumExclusiveValue;
    private final DiffContext context;

    @Override
    public DiffResult isChanged() {
        if (Objects.equals(this.oldMinimumValue, this.newMinimumValue) && Objects.equals(this.oldMaximumValue, this.newMaximumValue) && Objects.equals(this.oldMinimumExclusiveValue, this.newMinimumExclusiveValue) && Objects.equals(this.oldMaximumExclusiveValue, this.newMaximumExclusiveValue)) {
            return DiffResult.NO_CHANGES;
        }
        if (this.context.isRequest() && !BackwardIncompatibleProp.REQUEST_NUMERIC_RANGE_DECREASED.enabled(this.context, new Object[0]) || this.context.isResponse() && !BackwardIncompatibleProp.RESPONSE_NUMERIC_RANGE_INCREASED.enabled(this.context, new Object[0])) {
            return DiffResult.COMPATIBLE;
        }
        boolean exclusiveMaxOld = BooleanUtils.isTrue(this.oldMaximumExclusiveValue);
        boolean exclusiveMinOld = BooleanUtils.isTrue(this.oldMinimumExclusiveValue);
        boolean exclusiveMaxNew = BooleanUtils.isTrue(this.newMaximumExclusiveValue);
        boolean exclusiveMinNew = BooleanUtils.isTrue(this.newMinimumExclusiveValue);
        int diffMax = this.compare(this.oldMaximumValue, this.newMaximumValue, false);
        int diffMin = this.compare(this.oldMinimumValue, this.newMinimumValue, true);
        if (this.context.isRequest()) {
            if (diffMax > 0 || diffMax == 0 && !exclusiveMaxOld && exclusiveMaxNew) {
                return DiffResult.INCOMPATIBLE;
            }
            if (diffMin < 0 || diffMin == 0 && !exclusiveMinOld && exclusiveMinNew) {
                return DiffResult.INCOMPATIBLE;
            }
        } else if (this.context.isResponse()) {
            if (diffMax < 0 || diffMax == 0 && exclusiveMaxOld && !exclusiveMaxNew) {
                return DiffResult.INCOMPATIBLE;
            }
            if (diffMin > 0 || diffMin == 0 && exclusiveMinOld && !exclusiveMinNew) {
                return DiffResult.INCOMPATIBLE;
            }
        }
        return DiffResult.COMPATIBLE;
    }

    private int compare(BigDecimal left, BigDecimal right, boolean nullMeansLessThan) {
        if (left == null && right == null) {
            return 0;
        }
        if (left == null) {
            return nullMeansLessThan ? -1 : 1;
        }
        if (right == null) {
            return nullMeansLessThan ? 1 : -1;
        }
        return left.unscaledValue().compareTo(right.unscaledValue());
    }

    public ChangedNumericRange(BigDecimal oldMinimumValue, BigDecimal newMinimumValue, BigDecimal oldMaximumValue, BigDecimal newMaximumValue, Boolean oldMinimumExclusiveValue, Boolean newMinimumExclusiveValue, Boolean oldMaximumExclusiveValue, Boolean newMaximumExclusiveValue, DiffContext context) {
        this.oldMinimumValue = oldMinimumValue;
        this.newMinimumValue = newMinimumValue;
        this.oldMaximumValue = oldMaximumValue;
        this.newMaximumValue = newMaximumValue;
        this.oldMinimumExclusiveValue = oldMinimumExclusiveValue;
        this.newMinimumExclusiveValue = newMinimumExclusiveValue;
        this.oldMaximumExclusiveValue = oldMaximumExclusiveValue;
        this.newMaximumExclusiveValue = newMaximumExclusiveValue;
        this.context = context;
    }

    public BigDecimal getOldMinimumValue() {
        return this.oldMinimumValue;
    }

    public BigDecimal getNewMinimumValue() {
        return this.newMinimumValue;
    }

    public BigDecimal getOldMaximumValue() {
        return this.oldMaximumValue;
    }

    public BigDecimal getNewMaximumValue() {
        return this.newMaximumValue;
    }

    public Boolean getOldMinimumExclusiveValue() {
        return this.oldMinimumExclusiveValue;
    }

    public Boolean getNewMinimumExclusiveValue() {
        return this.newMinimumExclusiveValue;
    }

    public Boolean getOldMaximumExclusiveValue() {
        return this.oldMaximumExclusiveValue;
    }

    public Boolean getNewMaximumExclusiveValue() {
        return this.newMaximumExclusiveValue;
    }

    public DiffContext getContext() {
        return this.context;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangedNumericRange that = (ChangedNumericRange)o;
        return Objects.equals(this.oldMinimumValue, this.newMinimumValue) && Objects.equals(this.oldMaximumValue, this.newMaximumValue) && Objects.equals(this.oldMinimumExclusiveValue, this.newMinimumExclusiveValue) && Objects.equals(this.oldMaximumExclusiveValue, this.newMaximumExclusiveValue) && Objects.equals(this.context, that.context);
    }

    public int hashCode() {
        return Objects.hash(this.oldMinimumValue, this.newMinimumValue, this.oldMaximumValue, this.newMaximumValue, this.oldMinimumExclusiveValue, this.newMinimumExclusiveValue, this.oldMaximumExclusiveValue, this.newMaximumExclusiveValue, this.context);
    }

    public String toString() {
        return "ChangedNumericRange(oldMinimumValue=" + this.oldMinimumValue + ", newMinimumValue=" + this.newMinimumValue + ", oldMaximumValue=" + this.oldMaximumValue + ", newMaximumValue=" + this.newMaximumValue + ", oldMinimumExclusiveValue=" + this.oldMinimumExclusiveValue + ", newMinimumExclusiveValue=" + this.newMinimumExclusiveValue + ", oldMaximumExclusiveValue=" + this.oldMaximumExclusiveValue + ", newMaximumExclusiveValue=" + this.newMaximumExclusiveValue + ", context=" + this.context + ')';
    }
}

