/* SPDX-FileCopyrightText: 2019, 2025 - Sébastien Wilmet <swilmet@gnome.org>
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#pragma once

#if !defined (GTK_SOURCE_H_INSIDE) && !defined (GTK_SOURCE_COMPILATION)
#error "Only <gtksourceview/gtksource.h> can be included directly."
#endif

#include <glib.h>
#include <gmodule.h>

G_BEGIN_DECLS

typedef struct _GtkSourceIconv GtkSourceIconv;

/**
 * GtkSourceIconvResult:
 * @GTK_SOURCE_ICONV_RESULT_OK: Everything OK.
 * @GTK_SOURCE_ICONV_RESULT_ERROR: An error occurred.
 * @GTK_SOURCE_ICONV_RESULT_ILLEGAL_SEQUENCE: Stopped at an invalid character in
 *   the @inbuf; or the character could not be represented in the target
 *   character set. `*inbuf` is left pointing to the beginning of the invalid or
 *   unconvertible sequence.
 * @GTK_SOURCE_ICONV_RESULT_INCOMPLETE_INPUT: The input byte sequence ends with
 *   an incomplete multi-byte character. `*inbuf` is left pointing to the
 *   beginning of the incomplete multi-byte character.
 * @GTK_SOURCE_ICONV_RESULT_OUTPUT_BUFFER_FULL: The output buffer has no more
 *   room for the next converted character.
 * @GTK_SOURCE_ICONV_RESULT_LOSSY_CONVERSION: A number of nonreversible
 *   conversions have been performed.
 *
 * Used as the result value of gtk_source_iconv_feed().
 *
 * Since: 299.6
 */
typedef enum
{
	GTK_SOURCE_ICONV_RESULT_OK,
	GTK_SOURCE_ICONV_RESULT_ERROR,
	GTK_SOURCE_ICONV_RESULT_ILLEGAL_SEQUENCE,
	GTK_SOURCE_ICONV_RESULT_INCOMPLETE_INPUT,
	GTK_SOURCE_ICONV_RESULT_OUTPUT_BUFFER_FULL,
	GTK_SOURCE_ICONV_RESULT_LOSSY_CONVERSION,
} GtkSourceIconvResult;

G_MODULE_EXPORT
GtkSourceIconv *	gtk_source_iconv_new			(void);

G_MODULE_EXPORT
gboolean		gtk_source_iconv_open			(GtkSourceIconv  *conv,
								 const gchar     *to_codeset,
								 const gchar     *from_codeset,
								 GError         **error);

G_MODULE_EXPORT
GtkSourceIconvResult	gtk_source_iconv_feed			(GtkSourceIconv  *conv,
								 gchar          **inbuf,
								 gsize           *inbytes_left,
								 gchar          **outbuf,
								 gsize           *outbytes_left,
								 GError         **error);

G_MODULE_EXPORT
GtkSourceIconvResult	gtk_source_iconv_feed_discard_output	(GtkSourceIconv  *conv,
								 gchar          **inbuf,
								 gsize           *inbytes_left,
								 GError         **error);

G_MODULE_EXPORT
gboolean		gtk_source_iconv_close			(GtkSourceIconv  *conv,
								 GError         **error);

G_MODULE_EXPORT
void			gtk_source_iconv_free			(GtkSourceIconv *conv);

G_END_DECLS
