/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.events;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.keycloak.cluster.ClusterEvent;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.models.AbstractKeycloakTransaction;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.sessions.infinispan.events.SessionClusterEvent;

public class SessionEventsSenderTransaction
extends AbstractKeycloakTransaction {
    private final KeycloakSession session;
    private final Map<String, List<ClusterEvent>> sessionEvents = new HashMap<String, List<ClusterEvent>>();

    public SessionEventsSenderTransaction(KeycloakSession session) {
        this.session = session;
    }

    public void addEvent(SessionClusterEvent event) {
        this.sessionEvents.computeIfAbsent(event.getEventKey(), eventGroup -> new ArrayList()).add(event);
    }

    protected void commitImpl() {
        ClusterProvider cluster = (ClusterProvider)this.session.getProvider(ClusterProvider.class);
        for (Map.Entry<String, List<ClusterEvent>> entry : this.sessionEvents.entrySet()) {
            cluster.notify(entry.getKey(), (Collection)entry.getValue(), false);
        }
    }

    protected void rollbackImpl() {
        this.sessionEvents.clear();
    }
}

