/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.painter.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.api.SubstanceSkin;
import org.jvnet.substance.painter.decoration.DecorationAreaType;
import org.jvnet.substance.painter.decoration.SubstanceDecorationUtilities;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.watermark.SubstanceWatermark;

public class SubstanceFillBackgroundDelegate {
    private float watermarkAlpha;
    public static final SubstanceFillBackgroundDelegate GLOBAL_INSTANCE = new SubstanceFillBackgroundDelegate();

    public SubstanceFillBackgroundDelegate() {
        this(1.0f);
    }

    public SubstanceFillBackgroundDelegate(float watermarkAlpha) {
        this.watermarkAlpha = watermarkAlpha;
    }

    public void updateIfOpaque(Graphics g, Component c) {
        if (TransitionLayout.isOpaque(c)) {
            this.update(g, c, false);
        }
    }

    public void update(Graphics g, Component c, boolean force) {
        if (!SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            return;
        }
        boolean isInCellRenderer = c.getParent() instanceof CellRendererPane;
        boolean isPreviewMode = false;
        if (c instanceof JComponent) {
            isPreviewMode = Boolean.TRUE.equals(((JComponent)c).getClientProperty("lafwidgets.internal.previewMode"));
        }
        if (!(force || isPreviewMode || c.isShowing() || isInCellRenderer)) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics.setComposite(TransitionLayout.getAlphaComposite(c, g));
        DecorationAreaType decorationType = SubstanceDecorationUtilities.getDecorationType(c);
        SubstanceSkin skin = SubstanceCoreUtilities.getSkin(c);
        if (decorationType != null && skin.isRegisteredAsDecorationArea(decorationType)) {
            SubstanceDecorationUtilities.paintDecorationBackground(graphics, c, force);
        } else {
            SubstanceWatermark watermark;
            Color backgr = SubstanceColorUtilities.getBackgroundFillColor(c);
            graphics.setColor(backgr);
            graphics.fillRect(0, 0, c.getWidth(), c.getHeight());
            DecorationAreaType decorationAreaType = SubstanceDecorationUtilities.getDecorationType(c);
            boolean isPaintingDropShadows = skin.isPaintingDropShadows(decorationAreaType);
            if (isPaintingDropShadows) {
                Color fillColor = skin.getMainActiveColorScheme(decorationAreaType).getBackgroundFillColor().darker();
                int dy = 0;
                int totalOffsetY = 0;
                Component comp = c;
                while (comp.getParent() != null) {
                    Container parent = comp.getParent();
                    dy += comp.getY();
                    if (SubstanceDecorationUtilities.getImmediateDecorationType(parent) != null) {
                        totalOffsetY += dy;
                        dy = 0;
                    }
                    comp = parent;
                }
                graphics.translate(0, -totalOffsetY);
                graphics.setPaint(new GradientPaint(0.0f, 0.0f, SubstanceColorUtilities.getAlphaColor(fillColor, 160), 0.0f, 4.0f, SubstanceColorUtilities.getAlphaColor(fillColor, 16)));
                graphics.fillRect(0, 0, c.getWidth(), 4);
                graphics.translate(0, totalOffsetY);
            }
            if ((watermark = SubstanceCoreUtilities.getSkin(c).getWatermark()) != null && !isPreviewMode && !isInCellRenderer && c.isShowing() && SubstanceCoreUtilities.toDrawWatermark(c)) {
                watermark.drawWatermarkImage(graphics, c, 0, 0, c.getWidth(), c.getHeight());
            }
        }
        graphics.dispose();
    }

    public void fillAndWatermark(Graphics g, JComponent c, Color fillColor, Rectangle rect) {
        if (!SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            return;
        }
        boolean isInCellRenderer = c.getParent() instanceof CellRendererPane;
        if (!c.isShowing() && !isInCellRenderer) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setComposite(TransitionLayout.getAlphaComposite((Component)c, g));
        graphics.setColor(fillColor);
        graphics.fillRect(rect.x, rect.y, rect.width, rect.height);
        graphics.setComposite(TransitionLayout.getAlphaComposite(c, this.watermarkAlpha, g));
        SubstanceWatermark watermark = SubstanceCoreUtilities.getSkin(c).getWatermark();
        if (watermark != null && !isInCellRenderer && c.isShowing() && SubstanceCoreUtilities.toDrawWatermark(c)) {
            watermark.drawWatermarkImage(graphics, c, rect.x, rect.y, rect.width, rect.height);
        }
        graphics.dispose();
    }

    public void setWatermarkAlpha(float watermarkAlpha) {
        this.watermarkAlpha = watermarkAlpha;
    }
}

