/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.util;

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class WindowOnTopListener
implements AncestorListener,
WindowFocusListener {
    private boolean wasAlwaysOnTop;

    @Override
    public void windowGainedFocus(WindowEvent e) {
        Window window = e.getWindow();
        if (window != null && window.isAlwaysOnTop() != this.wasAlwaysOnTop) {
            window.setAlwaysOnTop(this.wasAlwaysOnTop);
        }
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
        Window window = e.getWindow();
        if (window != null) {
            this.wasAlwaysOnTop = window.isAlwaysOnTop();
        }
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        Container ancestor = event.getAncestor();
        if (ancestor instanceof Dialog) {
            Dialog dialog = (Dialog)ancestor;
            this.wasAlwaysOnTop = dialog.isAlwaysOnTop();
            if (dialog.isVisible() && dialog.isModal()) {
                dialog.setAlwaysOnTop(true);
            }
        }
        if (ancestor instanceof Window) {
            Window window = (Window)ancestor;
            window.addWindowFocusListener(this);
        }
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
        Dialog dialog;
        Container ancestor = event.getAncestor();
        if (ancestor instanceof Dialog && (dialog = (Dialog)ancestor).isVisible() && dialog.isModal()) {
            dialog.setAlwaysOnTop(this.wasAlwaysOnTop);
        }
        if (ancestor instanceof Window) {
            Window window = (Window)ancestor;
            window.removeWindowFocusListener(this);
        }
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }
}

