/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.ac;

import java.util.Comparator;
import java.util.Objects;
import org.openstreetmap.josm.gui.widgets.JosmComboBoxModel;

public class AutoCompComboBoxModel<E>
extends JosmComboBoxModel<E> {
    private Comparator<E> comparator;

    public AutoCompComboBoxModel() {
        this.setComparator(Comparator.comparing(Object::toString));
    }

    public AutoCompComboBoxModel(Comparator<E> comparator) {
        this.setComparator(comparator);
    }

    public void setComparator(Comparator<E> comparator) {
        Objects.requireNonNull(comparator, "A comparator cannot be null.");
        this.comparator = comparator;
    }

    public E findBestCandidate(String prefix) {
        return this.elements.stream().filter(o -> o.toString().startsWith(prefix)).min((x, y) -> x.toString().equals(prefix) ? -1 : (y.toString().equals(prefix) ? 1 : this.comparator.compare(x, y))).orElse(null);
    }
}

