/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Expand the size of an image by an integer factor in each dimension.


ExpandImageFilter increases the size of an image by an integer factor in each dimension
using a interpolation method. The output image size in each dimension
is given by:

OutputSize[j] = InputSize[j] * ExpandFactors[j]

The output values are obtained by interpolating the input image. The
default interpolation type used is the LinearInterpolateImageFunction . The user can specify a particular interpolation function via SetInterpolator() . Note that the input interpolator must derive from base class InterpolateImageFunction .

This filter will produce an output with different pixel spacing that
its input image such that:

OutputSpacing[j] = InputSpacing[j] / ExpandFactors[j]

The filter is templated over the input image type and the output image
type.

This filter is implemented as a multithreaded filter and supports
streaming.

This filter assumes that the input and output image has the same
number of dimensions.


See:
 InterpolateImageFunction

 LinearInterpolationImageFunction

 itk::simple::Expand for the procedural interface

 itk::ExpandImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkExpandImageFilter.h
*/
public class ExpandImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected ExpandImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.ExpandImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(ExpandImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(ExpandImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::ExpandImageFilter::~ExpandImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_ExpandImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::ExpandImageFilter::ExpandImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  ExpandImageFilter() {
    this(SimpleITKJNI.new_ExpandImageFilter(), true);
  }

  /**
Self&amp; itk::simple::ExpandImageFilter::SetExpandFactor(unsigned int e)

Custom public declarations

*/
public  void setExpandFactor(long e) {
    SimpleITKJNI.ExpandImageFilter_setExpandFactor(swigCPtr, this, e);
  }

  /**
Self&amp; itk::simple::ExpandImageFilter::SetExpandFactors(unsigned int value)

Set the values of the ExpandFactors vector all to value

*/
public  void setExpandFactors(VectorUInt32 ExpandFactors) {
    SimpleITKJNI.ExpandImageFilter_setExpandFactors__SWIG_0(swigCPtr, this, VectorUInt32.getCPtr(ExpandFactors), ExpandFactors);
  }

  /**
Self&amp; itk::simple::ExpandImageFilter::SetExpandFactors(unsigned int value)

Set the values of the ExpandFactors vector all to value

*/
public  void setExpandFactors(long value) {
    SimpleITKJNI.ExpandImageFilter_setExpandFactors__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::ExpandImageFilter::GetExpandFactors() const

Get the expand factors.

*/
public  VectorUInt32 getExpandFactors() {
    return new VectorUInt32(SimpleITKJNI.ExpandImageFilter_getExpandFactors(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::ExpandImageFilter::SetInterpolator(InterpolatorEnum Interpolator)

Get/Set the interpolator function.

*/
public  void setInterpolator(InterpolatorEnum Interpolator) {
    SimpleITKJNI.ExpandImageFilter_setInterpolator(swigCPtr, this, Interpolator.swigValue());
  }

  /**
InterpolatorEnum itk::simple::ExpandImageFilter::GetInterpolator() const

Get/Set the interpolator function.

*/
public  InterpolatorEnum getInterpolator() {
    return InterpolatorEnum.swigToEnum(SimpleITKJNI.ExpandImageFilter_getInterpolator(swigCPtr, this));
  }

  /**
std::string itk::simple::ExpandImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.ExpandImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::ExpandImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.ExpandImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::ExpandImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.ExpandImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
