/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.gradle.api.credentials.PasswordCredentials;
import org.gradle.api.resources.ResourceException;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.transfer.ExternalResourceLister;
import org.gradle.internal.resource.transport.sftp.LockableSftpClient;
import org.gradle.internal.resource.transport.sftp.SftpClientFactory;

public class SftpResourceLister
implements ExternalResourceLister {
    private final SftpClientFactory sftpClientFactory;
    private final PasswordCredentials credentials;

    public SftpResourceLister(SftpClientFactory sftpClientFactory, PasswordCredentials credentials) {
        this.sftpClientFactory = sftpClientFactory;
        this.credentials = credentials;
    }

    public List<String> list(ExternalResourceName directory) {
        LockableSftpClient client = this.sftpClientFactory.createSftpClient(directory.getUri(), this.credentials);
        try {
            Vector entries = client.getSftpClient().ls(directory.getPath());
            ArrayList<String> list = new ArrayList<String>();
            for (ChannelSftp.LsEntry entry : entries) {
                list.add(entry.getFilename());
            }
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        catch (SftpException e) {
            if (e.id == 2) {
                List<String> list = null;
                return list;
            }
            throw new ResourceException(directory.getUri(), String.format("Could not list children for resource '%s'.", directory.getUri()), (Throwable)e);
        }
        finally {
            this.sftpClientFactory.releaseSftpClient(client);
        }
    }
}

