/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.bridge.EchoSVGWrapFactory;
import io.sf.carte.echosvg.bridge.EventTargetWrapper;
import io.sf.carte.echosvg.bridge.InterruptedBridgeException;
import io.sf.carte.echosvg.bridge.RhinoInterpreterFactory;
import io.sf.carte.echosvg.bridge.SecurityHelper;
import io.sf.carte.echosvg.bridge.Window;
import io.sf.carte.echosvg.bridge.WindowWrapper;
import io.sf.carte.echosvg.script.ImportInfo;
import io.sf.carte.echosvg.script.Interpreter;
import io.sf.carte.echosvg.script.InterpreterException;
import io.sf.carte.echosvg.script.rhino.EchoSVGSecurityController;
import io.sf.carte.echosvg.script.rhino.RhinoClassLoader;
import io.sf.carte.echosvg.script.rhino.RhinoClassShutter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.mozilla.javascript.ClassCache;
import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.WrapFactory;
import org.mozilla.javascript.WrappedException;
import org.w3c.dom.events.EventTarget;

public class RhinoInterpreter
implements Interpreter {
    private static final int MAX_CACHED_SCRIPTS = 32;
    public static final String SOURCE_NAME_SVG = "<SVG>";
    public static final String BIND_NAME_WINDOW = "window";
    protected static List<?> contexts = new LinkedList();
    protected Window window;
    protected ScriptableObject globalObject = null;
    protected LinkedList<Entry> compiledScripts = new LinkedList();
    protected WrapFactory wrapFactory = new EchoSVGWrapFactory(this);
    protected ClassShutter classShutter = new RhinoClassShutter();
    protected RhinoClassLoader rhinoClassLoader;
    private EchoSVGSecurityController securityController = EchoSVGSecurityController.getInstance();
    protected ContextFactory contextFactory = new Factory();
    protected Context defaultContext;

    public RhinoInterpreter(URL documentURL) {
        this.init(documentURL, null);
    }

    public RhinoInterpreter(URL documentURL, ImportInfo imports) {
        this.init(documentURL, imports);
    }

    protected void init(URL documentURL, final ImportInfo imports) {
        try {
            this.rhinoClassLoader = new RhinoClassLoader(documentURL, this.getClass().getClassLoader());
        }
        catch (SecurityException se) {
            this.rhinoClassLoader = null;
        }
        ContextAction<Object> initAction = new ContextAction<Object>(){

            public Object run(Context cx) {
                ScriptableObject scriptable = cx.initStandardObjects(null, false);
                RhinoInterpreter.this.defineGlobalWrapperClass((Scriptable)scriptable);
                RhinoInterpreter.this.globalObject = RhinoInterpreter.this.createGlobalObject(cx);
                ClassCache cache = ClassCache.get((Scriptable)RhinoInterpreter.this.globalObject);
                cache.setCachingEnabled(RhinoInterpreter.this.rhinoClassLoader != null);
                ImportInfo ii = imports;
                if (ii == null) {
                    ii = ImportInfo.getImports();
                }
                StringBuilder sb = new StringBuilder();
                Iterator iter = ii.getPackages();
                while (iter.hasNext()) {
                    String pkg = (String)iter.next();
                    sb.append("importPackage(Packages.");
                    sb.append(pkg);
                    sb.append(");");
                }
                iter = ii.getClasses();
                while (iter.hasNext()) {
                    String cls = (String)iter.next();
                    sb.append("importClass(Packages.");
                    sb.append(cls);
                    sb.append(");");
                }
                cx.evaluateString((Scriptable)RhinoInterpreter.this.globalObject, sb.toString(), null, 0, (Object)RhinoInterpreter.this.rhinoClassLoader);
                return null;
            }
        };
        this.contextFactory.call((ContextAction)initAction);
    }

    public String[] getMimeTypes() {
        return RhinoInterpreterFactory.RHINO_MIMETYPES;
    }

    public Window getWindow() {
        return this.window;
    }

    public ContextFactory getContextFactory() {
        return this.contextFactory;
    }

    protected void defineGlobalWrapperClass(Scriptable global) {
        try {
            ScriptableObject.defineClass((Scriptable)global, WindowWrapper.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected ScriptableObject createGlobalObject(Context ctx) {
        return new WindowWrapper(ctx);
    }

    public Object getAccessControlObject() {
        if (this.rhinoClassLoader == null) {
            return null;
        }
        return this.rhinoClassLoader.getAccessControlObject();
    }

    protected ScriptableObject getGlobalObject() {
        return this.globalObject;
    }

    public Object evaluate(Reader scriptreader) throws IOException {
        return this.evaluate(scriptreader, SOURCE_NAME_SVG);
    }

    public Object evaluate(final Reader scriptReader, final String description) throws IOException {
        ContextAction<Object> evaluateAction = new ContextAction<Object>(){

            public Object run(Context cx) {
                try {
                    return cx.evaluateReader((Scriptable)RhinoInterpreter.this.globalObject, scriptReader, description, 1, (Object)RhinoInterpreter.this.rhinoClassLoader);
                }
                catch (IOException ioe) {
                    throw new WrappedException((Throwable)ioe);
                }
            }
        };
        try {
            return this.contextFactory.call((ContextAction)evaluateAction);
        }
        catch (JavaScriptException e) {
            Object value = e.getValue();
            Throwable ex = value instanceof Exception ? (Exception)value : e;
            throw new InterpreterException((Exception)ex, ex.getMessage(), -1, -1);
        }
        catch (WrappedException we) {
            Throwable w = we.getWrappedException();
            if (w instanceof Exception) {
                throw new InterpreterException((Exception)w, w.getMessage(), -1, -1);
            }
            throw new InterpreterException(w.getMessage(), -1, -1);
        }
        catch (InterruptedBridgeException ibe) {
            throw ibe;
        }
        catch (RuntimeException re) {
            throw new InterpreterException((Exception)re, re.getMessage(), -1, -1);
        }
    }

    public Object evaluate(final String scriptStr) {
        ContextAction<Object> evalAction = new ContextAction<Object>(){

            public Object run(final Context cx) {
                Script script = null;
                Entry entry = null;
                Iterator it = RhinoInterpreter.this.compiledScripts.iterator();
                while (it.hasNext()) {
                    entry = (Entry)it.next();
                    if (!entry.str.equals(scriptStr)) continue;
                    script = entry.script;
                    it.remove();
                    break;
                }
                if (script == null) {
                    PrivilegedAction<Object> compile = new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            try {
                                return cx.compileReader((Reader)new StringReader(scriptStr), RhinoInterpreter.SOURCE_NAME_SVG, 1, (Object)RhinoInterpreter.this.rhinoClassLoader);
                            }
                            catch (IOException ioEx) {
                                throw new RuntimeException(ioEx.getMessage());
                            }
                        }
                    };
                    script = (Script)SecurityHelper.getInstance().runPrivilegedAction(compile);
                    if (RhinoInterpreter.this.compiledScripts.size() + 1 > 32) {
                        RhinoInterpreter.this.compiledScripts.removeFirst();
                    }
                    RhinoInterpreter.this.compiledScripts.addLast(new Entry(scriptStr, script));
                } else {
                    RhinoInterpreter.this.compiledScripts.addLast(entry);
                }
                return script.exec(cx, (Scriptable)RhinoInterpreter.this.globalObject);
            }
        };
        try {
            return this.contextFactory.call((ContextAction)evalAction);
        }
        catch (InterpreterException ie) {
            throw ie;
        }
        catch (JavaScriptException e) {
            Object value = e.getValue();
            Throwable ex = value instanceof Exception ? (Exception)value : e;
            throw new InterpreterException((Exception)ex, ex.getMessage(), -1, -1);
        }
        catch (WrappedException we) {
            Throwable w = we.getWrappedException();
            if (w instanceof Exception) {
                throw new InterpreterException((Exception)w, w.getMessage(), -1, -1);
            }
            throw new InterpreterException(w.getMessage(), -1, -1);
        }
        catch (RuntimeException re) {
            throw new InterpreterException((Exception)re, re.getMessage(), -1, -1);
        }
    }

    public void dispose() {
        if (this.rhinoClassLoader != null) {
            ClassCache cache = ClassCache.get((Scriptable)this.globalObject);
            cache.setCachingEnabled(false);
        }
    }

    public void bindObject(final String name, final Object object) {
        this.contextFactory.call((ContextAction)new ContextAction<Object>(){

            public Object run(Context cx) {
                Object o = object;
                if (name.equals(RhinoInterpreter.BIND_NAME_WINDOW) && object instanceof Window) {
                    ((WindowWrapper)RhinoInterpreter.this.globalObject).window = (Window)object;
                    RhinoInterpreter.this.window = (Window)object;
                    o = RhinoInterpreter.this.globalObject;
                }
                Scriptable jsObject = Context.toObject((Object)o, (Scriptable)RhinoInterpreter.this.globalObject);
                RhinoInterpreter.this.globalObject.put(name, (Scriptable)RhinoInterpreter.this.globalObject, (Object)jsObject);
                return null;
            }
        });
    }

    void callHandler(final Function handler, final Object arg) {
        this.contextFactory.call((ContextAction)new ContextAction<Object>(){

            public Object run(Context cx) {
                Scriptable a = Context.toObject((Object)arg, (Scriptable)RhinoInterpreter.this.globalObject);
                Object[] args = new Object[]{a};
                handler.call(cx, (Scriptable)RhinoInterpreter.this.globalObject, (Scriptable)RhinoInterpreter.this.globalObject, args);
                return null;
            }
        });
    }

    void callMethod(final ScriptableObject obj, final String methodName, final ArgumentsBuilder ab) {
        this.contextFactory.call((ContextAction)new ContextAction<Object>(){

            public Object run(Context cx) {
                ScriptableObject.callMethod((Scriptable)obj, (String)methodName, (Object[])ab.buildArguments());
                return null;
            }
        });
    }

    void callHandler(final Function handler, final Object[] args) {
        this.contextFactory.call((ContextAction)new ContextAction<Object>(){

            public Object run(Context cx) {
                handler.call(cx, (Scriptable)RhinoInterpreter.this.globalObject, (Scriptable)RhinoInterpreter.this.globalObject, args);
                return null;
            }
        });
    }

    void callHandler(final Function handler, final ArgumentsBuilder ab) {
        this.contextFactory.call((ContextAction)new ContextAction<Object>(){

            public Object run(Context cx) {
                Object[] args = ab.buildArguments();
                handler.call(cx, handler.getParentScope(), (Scriptable)RhinoInterpreter.this.globalObject, args);
                return null;
            }
        });
    }

    Object call(ContextAction<?> action) {
        return this.contextFactory.call(action);
    }

    Scriptable buildEventTargetWrapper(EventTarget obj) {
        return new EventTargetWrapper((Scriptable)this.globalObject, obj, this);
    }

    public void setOut(Writer out) {
    }

    public Locale getLocale() {
        return null;
    }

    public void setLocale(Locale locale) {
    }

    public String formatMessage(String key, Object[] args) {
        return null;
    }

    protected class Factory
    extends ContextFactory {
        protected Factory() {
        }

        protected Context makeContext() {
            Context cx = super.makeContext();
            cx.setWrapFactory(RhinoInterpreter.this.wrapFactory);
            cx.setSecurityController((SecurityController)RhinoInterpreter.this.securityController);
            cx.setClassShutter(RhinoInterpreter.this.classShutter);
            if (RhinoInterpreter.this.rhinoClassLoader == null) {
                cx.setOptimizationLevel(-1);
            }
            return cx;
        }
    }

    public static interface ArgumentsBuilder {
        public Object[] buildArguments();
    }

    protected static class Entry {
        public String str;
        public Script script;

        public Entry(String str, Script script) {
            this.str = str;
            this.script = script;
        }
    }
}

