/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.DOMElement;
import io.sf.carte.doc.dom.ElementList;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import java.util.Iterator;
import java.util.LinkedList;
import org.w3c.dom.Node;

class DOMElementLinkedList
extends LinkedList<DOMElement>
implements ElementList {
    private static final long serialVersionUID = 2L;

    DOMElementLinkedList() {
    }

    @Override
    public boolean contains(Node node) {
        return super.contains(node);
    }

    @Override
    public DOMElement item(int index) {
        if (index < 0 || index >= this.size()) {
            return null;
        }
        return (DOMElement)this.get(index);
    }

    @Override
    public int getLength() {
        return this.size();
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(this.size() * 32 + 40);
        Iterator it = this.iterator();
        if (it.hasNext()) {
            buf.append(((DOMElement)it.next()).toString());
        }
        while (it.hasNext()) {
            buf.append(',').append(((DOMElement)it.next()).toString());
        }
        return buf.toString();
    }

    void fillQuerySelectorList(SelectorList selist, Node firstChild) {
        for (Node node = firstChild; node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            DOMElement element = (DOMElement)node;
            if (element.matches(selist, null)) {
                this.add(element);
            }
            this.fillQuerySelectorList(selist, element.getFirstChild());
        }
    }
}

