/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.HashMap;
import net.infonode.gui.layout.LayoutUtil;
import net.infonode.util.Direction;

public class DirectionLayout
implements LayoutManager2 {
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    private Direction direction;
    private HashMap componentInsets;
    private int componentSpacing;
    private boolean compressing;
    private ArrayList layoutOrderList;

    public DirectionLayout() {
        this(Direction.RIGHT);
    }

    public DirectionLayout(int componentSpacing) {
        this(Direction.RIGHT, componentSpacing);
    }

    public DirectionLayout(Direction direction) {
        this(direction, 0);
    }

    public DirectionLayout(Direction direction, int componentSpacing) {
        this.direction = direction;
        this.componentSpacing = componentSpacing;
    }

    public int getComponentSpacing() {
        return this.componentSpacing;
    }

    public void setComponentSpacing(int componentSpacing) {
        this.componentSpacing = componentSpacing;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public boolean isVertical() {
        return !this.direction.isHorizontal();
    }

    public boolean isCompressing() {
        return this.compressing;
    }

    public void setCompressing(boolean compressing) {
        this.compressing = compressing;
    }

    public void setLayoutOrderList(ArrayList layoutOrderList) {
        this.layoutOrderList = layoutOrderList;
    }

    private int getSize(Dimension d) {
        return (int)(this.isVertical() ? d.getHeight() : d.getWidth());
    }

    private static int getBeforeSpacing(Insets insets) {
        return insets.left;
    }

    private int getAfterSpacing(Component component, boolean isLast) {
        return this.getInsets((Component)component).right + (isLast ? 0 : this.componentSpacing);
    }

    private Dimension createSize(int size, int otherSize) {
        return this.isVertical() ? new Dimension(otherSize, size) : new Dimension(size, otherSize);
    }

    private static Dimension getSize(Dimension interiorSize, Container component) {
        Insets insets = component.getInsets();
        return new Dimension(interiorSize.width + insets.left + insets.right, interiorSize.height + insets.top + insets.bottom);
    }

    private int getOtherSize(Dimension dim) {
        return (int)(this.isVertical() ? dim.getWidth() : dim.getHeight());
    }

    private void setSize(Component component, int size, int otherSize) {
        int maxOtherSize = this.getOtherSize(component.getMaximumSize());
        component.setSize(this.createSize(size, Math.min(maxOtherSize, otherSize)));
    }

    @Override
    public void layoutContainer(Container parent) {
        int i;
        int lastCount;
        Component[] components = this.getVisibleChildren(parent);
        int count = components.length;
        if (components.length == 0) {
            return;
        }
        int totalSpacing = 0;
        int i2 = 0;
        while (i2 < components.length) {
            totalSpacing += this.getSpacing(components[i2], i2 == components.length - 1);
            ++i2;
        }
        boolean[] discarded = new boolean[components.length];
        Dimension parentInteriorSize = LayoutUtil.getInteriorSize(parent);
        int componentsTotalSize = this.getSize(parentInteriorSize) - totalSpacing;
        int maxComponentSize = componentsTotalSize / components.length;
        int otherSize = this.getOtherSize(parentInteriorSize);
        block1: do {
            lastCount = count;
            i = 0;
            while (i < components.length) {
                int prefSize;
                if (!discarded[i] && (prefSize = this.getSize(components[i].getPreferredSize())) <= maxComponentSize) {
                    this.setSize(components[i], prefSize, otherSize);
                    componentsTotalSize -= prefSize;
                    discarded[i] = true;
                    if (--count == 0) continue block1;
                    maxComponentSize = componentsTotalSize / count;
                }
                ++i;
            }
        } while (lastCount > count);
        if (count > 0) {
            block3: do {
                lastCount = count;
                i = 0;
                while (i < components.length) {
                    int minSize;
                    if (!discarded[i] && (minSize = this.getSize(components[i].getMinimumSize())) >= maxComponentSize) {
                        this.setSize(components[i], minSize, otherSize);
                        componentsTotalSize -= minSize;
                        discarded[i] = true;
                        if (--count == 0) continue block3;
                        maxComponentSize = componentsTotalSize / count;
                    }
                    ++i;
                }
            } while (lastCount > count);
        }
        Insets insets = parent.getInsets();
        int pos = this.direction == Direction.RIGHT ? insets.left : (this.direction == Direction.DOWN ? insets.top : (this.direction == Direction.LEFT ? insets.right : insets.bottom));
        int yOffset = this.isVertical() ? insets.left : insets.top;
        int i3 = 0;
        while (i3 < components.length) {
            pos += DirectionLayout.getBeforeSpacing(this.getInsets(components[i3]));
            if (!discarded[i3]) {
                int componentSize = Math.max(this.getSize(components[i3].getMinimumSize()), componentsTotalSize / count);
                this.setSize(components[i3], componentSize, otherSize);
                --count;
                componentsTotalSize -= componentSize;
            }
            int yPos = yOffset + (int)((float)(otherSize - this.getOtherSize(components[i3].getSize())) * (this.direction == Direction.DOWN || this.direction == Direction.LEFT ? 1.0f - components[i3].getAlignmentY() : components[i3].getAlignmentY()));
            if (this.isVertical()) {
                components[i3].setLocation(yPos, this.direction == Direction.DOWN ? pos : parent.getHeight() - pos - components[i3].getHeight());
            } else {
                components[i3].setLocation(this.direction == Direction.RIGHT ? pos : parent.getWidth() - pos - components[i3].getWidth(), yPos);
            }
            pos += this.getSize(components[i3].getSize()) + this.getAfterSpacing(components[i3], i3 == components.length - 1);
            ++i3;
        }
    }

    public void setComponentInsets(Component c, Insets i) {
        if (i == null) {
            this.removeLayoutComponent(c);
        } else {
            if (this.componentInsets == null) {
                this.componentInsets = new HashMap(4);
            }
            this.componentInsets.put(c, i);
        }
    }

    private Component[] getVisibleChildren(Container parent) {
        if (this.layoutOrderList != null) {
            Component[] components = new Component[this.layoutOrderList.size()];
            int i = 0;
            while (i < this.layoutOrderList.size()) {
                components[i] = (Component)this.layoutOrderList.get(i);
                ++i;
            }
            return LayoutUtil.getVisibleChildren(components);
        }
        return LayoutUtil.getVisibleChildren(parent);
    }

    private int getSpacing(Component component, boolean isLast) {
        Insets insets = this.getInsets(component);
        return insets.left + insets.right + (isLast ? 0 : this.componentSpacing);
    }

    private Insets getInsets(Component component) {
        Object o = this.componentInsets == null ? null : this.componentInsets.get(component);
        return o == null ? EMPTY_INSETS : (Insets)o;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Component[] c = this.getVisibleChildren(parent);
        int size = 0;
        int maxHeight = 0;
        int i = 0;
        while (i < c.length) {
            size += this.getSize(c[i].getMinimumSize()) + this.getSpacing(c[i], i == c.length - 1);
            maxHeight = Math.max(this.getOtherSize(c[i].getMinimumSize()), maxHeight);
            ++i;
        }
        Dimension d = DirectionLayout.getSize(this.isVertical() ? new Dimension(maxHeight, size) : new Dimension(size, maxHeight), parent);
        return d;
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Component[] c = this.getVisibleChildren(parent);
        int size = 0;
        int maxHeight = 0;
        int i = 0;
        while (i < c.length) {
            if (!this.compressing) {
                size += this.getSize(c[i].getPreferredSize()) + this.getSpacing(c[i], i == c.length - 1);
            }
            maxHeight = Math.max(this.getOtherSize(c[i].getPreferredSize()), maxHeight);
            ++i;
        }
        Dimension d = DirectionLayout.getSize(this.isVertical() ? new Dimension(maxHeight, size) : new Dimension(size, maxHeight), parent);
        return d;
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        if (this.componentInsets != null) {
            this.componentInsets.remove(comp);
            if (this.componentInsets.size() == 0) {
                this.componentInsets = null;
            }
        }
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        this.setComponentInsets(comp, (Insets)constraints);
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    @Override
    public Dimension maximumLayoutSize(Container parent) {
        Component[] c = this.getVisibleChildren(parent);
        int size = 0;
        int maxHeight = Integer.MAX_VALUE;
        int i = 0;
        while (i < c.length) {
            size += this.getSize(c[i].getMaximumSize()) + this.getSpacing(c[i], i == c.length - 1);
            ++i;
        }
        Dimension d = DirectionLayout.getSize(this.isVertical() ? new Dimension(maxHeight, size) : new Dimension(size, maxHeight), parent);
        return d;
    }
}

