/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.cubrid.model.CubridDataSource;
import org.jkiss.dbeaver.ext.cubrid.model.CubridTable;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCStructureAssistant;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.struct.AbstractObjectReference;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;

public class CubridStructureAssistant
extends JDBCStructureAssistant<JDBCExecutionContext> {
    private final CubridDataSource dataSource;

    public CubridStructureAssistant(CubridDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public JDBCDataSource getDataSource() {
        return this.dataSource;
    }

    protected void findObjectsByMask(JDBCExecutionContext executionContext, JDBCSession session, DBSObjectType objectType, DBSStructureAssistant.ObjectsSearchParams params, List<DBSObjectReference> references) throws DBException, SQLException {
        GenericSchema parentSchema;
        GenericSchema genericSchema = parentSchema = params.getParentObject() instanceof GenericSchema ? (GenericSchema)params.getParentObject() : null;
        if (objectType == RelationalObjectType.TYPE_TABLE) {
            this.findTablesByMask(session, parentSchema, params.getMask(), references);
        }
    }

    private void findTablesByMask(JDBCSession session, GenericSchema schema, String tableNameMask, List<DBSObjectReference> objects) throws SQLException, DBException {
        String sql = "SELECT class_name, owner_name, comment FROM db_class WHERE class_name = ?";
        try {
            JDBCPreparedStatement dbStat = session.prepareStatement(sql);
            dbStat.setString(1, tableNameMask);
            JDBCResultSet dbResult = dbStat.executeQuery();
            while (dbResult.next()) {
                String schemaName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"owner_name");
                String tableName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"class_name");
                String comment = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"comment");
                GenericSchema resolvedSchema = this.dataSource.getSchema(schemaName);
                if (resolvedSchema != null) {
                    objects.add((DBSObjectReference)new TableReference(resolvedSchema, tableName, comment));
                    continue;
                }
                throw new DBException("Schema not found for name: " + schemaName);
            }
        }
        catch (SQLException e) {
            throw new DBException("Failed to find tables matching: " + tableNameMask, (Throwable)e);
        }
    }

    private static final class TableReference
    extends AbstractObjectReference<GenericSchema> {
        private TableReference(GenericSchema container, String name, String comment) {
            super(name, (DBSObject)container, comment, CubridTable.class, RelationalObjectType.TYPE_TABLE);
        }

        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
            DBSObject table = ((GenericSchema)this.getContainer()).getTableCache().getObject(monitor, (DBSObject)((GenericStructContainer)this.getContainer()), this.getName());
            if (table == null) {
                throw new DBException(String.format("Table '%s' not found in schema '%s'", this.getName(), ((GenericSchema)this.getContainer()).getName()));
            }
            return table;
        }
    }
}

