/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.lzma;

import com.oracle.graal.python.builtins.modules.lzma.LZMAModuleBuiltins;
import com.oracle.graal.python.builtins.modules.lzma.LZMANodes;
import com.oracle.graal.python.builtins.objects.bytes.BytesUtils;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.runtime.NFILZMASupport;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.Shape;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.graalvm.shadowed.org.tukaani.xz.FilterOptions;
import org.graalvm.shadowed.org.tukaani.xz.FinishableOutputStream;
import org.graalvm.shadowed.org.tukaani.xz.LZMA2Options;
import org.graalvm.shadowed.org.tukaani.xz.LZMAInputStream;
import org.graalvm.shadowed.org.tukaani.xz.LZMAOutputStream;
import org.graalvm.shadowed.org.tukaani.xz.XZInputStream;
import org.graalvm.shadowed.org.tukaani.xz.XZOutputStream;

public abstract class LZMAObject
extends PythonBuiltinObject {
    protected int check;

    public LZMAObject(Object cls, Shape instanceShape) {
        super(cls, instanceShape);
    }

    public void setCheck(int check) {
        this.check = check;
    }

    public int getCheck() {
        return this.check;
    }

    public static LZMACompressor createCompressor(Object cls, Shape instanceShape, boolean isNative) {
        if (!isNative) {
            return new LZMACompressor.Java(cls, instanceShape);
        }
        return new LZMACompressor.Native(cls, instanceShape);
    }

    public static LZMADecompressor createDecompressor(Object cls, Shape instanceShape, boolean isNative) {
        if (!isNative) {
            return new LZMADecompressor.Java(cls, instanceShape);
        }
        return new LZMADecompressor.Native(cls, instanceShape);
    }

    public static abstract class LZMACompressor
    extends LZMAObject {
        private boolean flushed = false;

        public LZMACompressor(Object cls, Shape instanceShape) {
            super(cls, instanceShape);
        }

        public boolean isFlushed() {
            return this.flushed;
        }

        public void setFlushed() {
            this.flushed = true;
        }

        public static class Native
        extends LZMACompressor {
            private NFILZMASupport.Pointer pointer;

            public Native(Object cls, Shape instanceShape) {
                super(cls, instanceShape);
            }

            public final void init(Object lzmast, NFILZMASupport lib) {
                this.pointer = new NFILZMASupport.Pointer((Object)this, lzmast, lib);
            }

            public final Object getLzs() {
                assert (this.pointer != null);
                return this.pointer.getReference();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @CompilerDirectives.TruffleBoundary
            public final void markReleased() {
                if (this.pointer != null) {
                    Native native_ = this;
                    synchronized (native_) {
                        this.pointer.markReleased();
                        this.pointer = null;
                    }
                }
            }
        }

        public static class Java
        extends LZMACompressor {
            private FinishableOutputStream lzmaStream;
            private final ByteArrayOutputStream bos = BytesUtils.createOutputStream(8192);

            public Java(Object cls, Shape instanceShape) {
                super(cls, instanceShape);
            }

            @CompilerDirectives.TruffleBoundary
            public void lzmaStreamEncoder(FilterOptions[] optionsChain) throws IOException {
                this.lzmaStream = new XZOutputStream((OutputStream)this.bos, optionsChain, this.check);
            }

            @CompilerDirectives.TruffleBoundary
            public void lzmaEasyEncoder(LZMA2Options lzmaOptions) throws IOException {
                this.lzmaStream = new XZOutputStream((OutputStream)this.bos, (FilterOptions)lzmaOptions, this.check);
            }

            @CompilerDirectives.TruffleBoundary
            public void lzmaRawEncoder(FilterOptions[] optionsChain) throws IOException {
                this.lzmaStream = new LZMAOutputStream((OutputStream)this.bos, (LZMA2Options)optionsChain[0], true);
            }

            @CompilerDirectives.TruffleBoundary
            public void lzmaAloneEncoder(LZMA2Options lzmaOptions) throws IOException {
                this.lzmaStream = new LZMAOutputStream((OutputStream)this.bos, lzmaOptions, -1L);
            }

            @CompilerDirectives.TruffleBoundary
            public void write(byte[] bytes, int offset, int len) throws IOException {
                this.lzmaStream.write(bytes, offset, len);
            }

            @CompilerDirectives.TruffleBoundary
            public void finish() throws IOException {
                this.lzmaStream.finish();
            }

            public byte[] getByteArray() {
                return BytesUtils.toByteArray(this.bos);
            }

            @CompilerDirectives.TruffleBoundary
            public void resetBuffer() {
                this.bos.reset();
            }
        }
    }

    public static abstract class LZMADecompressor
    extends LZMAObject {
        protected int memlimit = Integer.MAX_VALUE;
        protected int format;
        private boolean eof = false;
        private byte[] unusedData = PythonUtils.EMPTY_BYTE_ARRAY;
        private boolean needsInput = true;
        private byte[] inputBuffer = null;
        private int inputBufferSize = 0;
        private int lzsAvailIn = 0;
        private int lzsAvailOut = 0;
        protected byte[] nextIn = null;
        private int nextInIndex = 0;

        public LZMADecompressor(Object cls, Shape instanceShape) {
            super(cls, instanceShape);
        }

        public void setMemlimit(int memlimit) {
            this.memlimit = memlimit;
        }

        public int getMemlimit() {
            return this.memlimit;
        }

        public void setFormat(int format) {
            this.format = format;
        }

        public boolean isEOF() {
            return this.eof;
        }

        public void setEOF() {
            this.eof = true;
        }

        public void setEOF(boolean b) {
            this.eof = b;
        }

        public byte[] getUnusedData() {
            return this.unusedData;
        }

        public void setUnusedData() {
            this.unusedData = Arrays.copyOfRange(this.nextIn, this.nextInIndex, this.nextInIndex + this.lzsAvailIn);
        }

        public boolean needsInput() {
            return this.needsInput;
        }

        public void setNeedsInput(boolean needsInput) {
            this.needsInput = needsInput;
        }

        public byte[] getInputBuffer() {
            return this.inputBuffer;
        }

        public void setInputBuffer(byte[] inputBuffer) {
            this.inputBuffer = inputBuffer;
        }

        public void createInputBuffer(int size) {
            this.inputBuffer = new byte[size];
            this.inputBufferSize = size;
        }

        public void discardInputBuffer() {
            this.inputBuffer = null;
            this.inputBufferSize = 0;
        }

        public void resizeInputBuffer(int size) {
            assert (size >= this.inputBufferSize);
            byte[] tmp = new byte[size];
            if (this.inputBuffer != null && this.lzsAvailIn != 0) {
                PythonUtils.arraycopy(this.inputBuffer, 0, tmp, 0, this.inputBuffer.length);
            }
            this.inputBuffer = tmp;
            this.inputBufferSize = size;
        }

        public int getInputBufferSize() {
            return this.inputBufferSize;
        }

        public void setInputBufferSize(int inputBufferSize) {
            this.inputBufferSize = inputBufferSize;
        }

        public byte[] getNextIn() {
            return this.nextIn;
        }

        public void setNextIn(byte[] in) {
            assert (in != null);
            this.nextIn = in;
        }

        public void clearNextIn() {
            this.nextIn = null;
        }

        public int getNextInIndex() {
            return this.nextInIndex;
        }

        public void setNextInIndex(int nextInIndex) {
            this.nextInIndex = nextInIndex;
        }

        public void setNextInIndex(long nextInIndex) throws OverflowException {
            this.nextInIndex = PInt.intValueExact(nextInIndex);
        }

        public int getLzsAvailIn() {
            return this.lzsAvailIn;
        }

        public int getLzsAvailOut() {
            return this.lzsAvailOut;
        }

        public void incLzsAvailIn(int size) {
            this.lzsAvailIn += size;
        }

        public void setLzsAvailIn(int lzsAvailIn) {
            this.lzsAvailIn = lzsAvailIn;
        }

        public void setLzsAvailIn(long lzsAvailIn) throws OverflowException {
            this.lzsAvailIn = PInt.intValueExact(lzsAvailIn);
        }

        public void setLzsAvailOut(int lzsAvailOut) {
            this.lzsAvailOut = lzsAvailOut;
        }

        public void setLzsAvailOut(long lzsAvailOut) throws OverflowException {
            this.lzsAvailOut = PInt.intValueExact(lzsAvailOut);
        }

        public static class Native
        extends LZMADecompressor {
            private NFILZMASupport.Pointer pointer;

            public Native(Object cls, Shape instanceShape) {
                super(cls, instanceShape);
            }

            public final void init(Object lzmast, NFILZMASupport lib) {
                this.pointer = new NFILZMASupport.Pointer((Object)this, lzmast, lib);
            }

            public final Object getLzs() {
                assert (this.pointer != null);
                return this.pointer.getReference();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @CompilerDirectives.TruffleBoundary
            public final void markReleased() {
                if (this.pointer != null) {
                    Native native_ = this;
                    synchronized (native_) {
                        this.pointer.markReleased();
                        this.pointer = null;
                    }
                }
            }
        }

        public static class Java
        extends LZMADecompressor {
            private LZMANodes.LZMAByteInputStream input;
            private InputStream lzs;
            private int currentAutoFormat;
            private int currentDataSize;
            private boolean decompressed;

            public Java(Object cls, Shape instanceShape) {
                super(cls, instanceShape);
            }

            public boolean isFormatAuto() {
                return this.format == LZMAModuleBuiltins.FORMAT_AUTO;
            }

            @CompilerDirectives.TruffleBoundary
            public void initialize() throws IOException {
                if (this.format == LZMAModuleBuiltins.FORMAT_AUTO) {
                    this.switchStream();
                } else if (this.format == LZMAModuleBuiltins.FORMAT_XZ) {
                    this.createXZ();
                } else if (this.format == LZMAModuleBuiltins.FORMAT_ALONE) {
                    this.createLZMA();
                } else {
                    throw new IllegalStateException();
                }
            }

            public boolean isInitialized() {
                return this.lzs != null;
            }

            @CompilerDirectives.TruffleBoundary
            public void setInput() {
                if (this.input == null) {
                    this.input = Java.createLZMAByteInputStream(this.getNextIn(), this.getNextInIndex(), this.getLzsAvailIn());
                } else {
                    this.input.setBuffer(this.getNextIn(), this.getNextInIndex());
                }
            }

            @CompilerDirectives.TruffleBoundary
            public void adjustNextIn() {
                int pos = this.input.getNextInIndex();
                byte[] tmp = Arrays.copyOfRange(this.getNextIn(), pos, this.getNextIn().length);
                this.setNextIn(tmp);
                this.setNextInIndex(0);
            }

            @CompilerDirectives.TruffleBoundary
            public int read(byte[] result) throws IOException {
                return this.lzs.read(result);
            }

            @CompilerDirectives.TruffleBoundary
            public void update(int availOut) {
                this.setNextInIndex(this.input.getNextInIndex());
                this.setLzsAvailIn(this.input.getAvailIn());
                this.setLzsAvailOut(availOut);
            }

            @CompilerDirectives.TruffleBoundary
            protected static LZMANodes.LZMAByteInputStream createLZMAByteInputStream(byte[] buf, int offset, int length) {
                return new LZMANodes.LZMAByteInputStream(buf, offset, length);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean sameData() {
                return this.currentDataSize == this.getNextIn().length;
            }

            @CompilerDirectives.TruffleBoundary
            public void decompressedData(int size) {
                boolean bl = this.decompressed = this.decompressed || size > 0;
                if (!this.decompressed && !this.sameData()) {
                    this.input.setBuffer(this.getNextIn(), this.getNextInIndex());
                    this.setLzsAvailIn(this.getNextIn().length);
                    this.currentDataSize = this.getNextIn().length;
                    this.currentAutoFormat = 0;
                    this.lzs = null;
                }
            }

            @CompilerDirectives.TruffleBoundary
            public void switchStream() throws IOException {
                this.setNextInIndex(this.input.getNextInIndex());
                if (this.currentAutoFormat == LZMAModuleBuiltins.FORMAT_XZ) {
                    this.currentAutoFormat = LZMAModuleBuiltins.FORMAT_ALONE;
                    if (this.getNextInIndex() >= 12) {
                        this.setNextInIndex(this.getNextInIndex() - 12);
                    }
                    this.input.setBuffer(this.getNextIn(), this.getNextInIndex());
                    this.createLZMA();
                } else {
                    this.currentAutoFormat = LZMAModuleBuiltins.FORMAT_XZ;
                    this.input.setBuffer(this.getNextIn(), this.getNextInIndex());
                    this.createXZ();
                }
                this.setLzsAvailIn(this.input.getAvailIn());
            }

            @CompilerDirectives.TruffleBoundary
            public void createXZ() throws IOException {
                this.lzs = new XZInputStream((InputStream)this.input, this.memlimit);
            }

            @CompilerDirectives.TruffleBoundary
            public void createLZMA() throws IOException {
                this.lzs = new LZMAInputStream((InputStream)this.input, this.memlimit);
            }
        }
    }
}

