\name{InverseDeconvolutionImageFilter}
\alias{InverseDeconvolutionImageFilter}
\title{InverseDeconvolutionImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
The direct linear inverse deconvolution filter.
InverseDeconvolutionImageFilter}
\details{
The inverse filter is the most straightforward deconvolution method.
Considering that convolution of two images in the spatial domain is
equivalent to multiplying the Fourier transform of the two images, the
inverse filter consists of inverting the multiplication. In other
words, this filter computes the following: \deqn{ hat{F}(\omega) = \begin{cases} G(\omega) / H(\omega) if |H(\omega)| \geq \epsilon \\ 0 otherwise \end{cases} } where \eqn{\hat{F}(\omega)} is the Fourier transform of the estimate produced by this filter, \eqn{G(\omega)} is the Fourier transform of the input blurred image, \eqn{H(\omega)} is the Fourier transform of the blurring kernel, and \eqn{\epsilon} is a constant real non-negative threshold (called
KernelZeroMagnitudeThreshold in this filter) that determines when the
magnitude of a complex number is considered zero.
Gaetan Lehmann, Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France
Cory Quammen, The University of North Carolina at Chapel Hill
See:
InverseDeconvolution for the procedural interface
itk::InverseDeconvolutionImageFilter for the Doxygen on the original ITK class.
InverseDeconvolutionImageFilter}
%C++ includes: sitkInverseDeconvolutionImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1, const Image &image2):}{
Execute the filter on the input images
}
\item{BoundaryConditionType GetBoundaryCondition() const:}{}
\item{double GetKernelZeroMagnitudeThreshold() const:}{
Set/get the threshold value used to determine whether a frequency of
the Fourier transform of the blurring kernel is considered to be zero.
Default value is 1.0e-4.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{bool GetNormalize() const:}{}
\item{OutputRegionModeType GetOutputRegionMode() const:}{}
\item{ InverseDeconvolutionImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self NormalizeOff():}{}
\item{Self NormalizeOn():}{
Set the value of Normalize to true or false respectfully.
}
\item{Self SetBoundaryCondition(BoundaryConditionType BoundaryCondition):}{}
\item{Self SetKernelZeroMagnitudeThreshold(double KernelZeroMagnitudeThreshold):}{
Set/get the threshold value used to determine whether a frequency of
the Fourier transform of the blurring kernel is considered to be zero.
Default value is 1.0e-4.
}
\item{Self SetNormalize(bool Normalize):}{
Normalize the output image by the sum of the kernel components
}
\item{Self SetOutputRegionMode(OutputRegionModeType OutputRegionMode):}{}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~InverseDeconvolutionImageFilter():}{
Destructor
}
}
}
