/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tests.bazel;

import com.intellij.tests.bazel.SafeXml;
import com.intellij.tests.bazel.TestData;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.Duration;
import java.time.Instant;
import java.util.Locale;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.listeners.LegacyReportingUtils;

class TestCaseXmlRenderer {
    private static final DecimalFormatSymbols DECIMAL_FORMAT_SYMBOLS = new DecimalFormatSymbols(Locale.ROOT);
    private final TestPlan testPlan;

    public TestCaseXmlRenderer(TestPlan testPlan) {
        this.testPlan = testPlan;
    }

    public void toXml(XMLStreamWriter xml, TestData test) throws XMLStreamException {
        String name;
        DecimalFormat decimalFormat = new DecimalFormat("#.##", DECIMAL_FORMAT_SYMBOLS);
        decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
        TestIdentifier id = test.getId();
        if (test.isDynamic()) {
            name = id.getDisplayName();
        } else {
            name = id.getLegacyReportingName();
            int index = name.indexOf(40);
            if (index != -1) {
                name = name.substring(0, index);
            }
        }
        xml.writeStartElement("testcase");
        xml.writeAttribute("name", SafeXml.escapeIllegalCharacters(name));
        xml.writeAttribute("classname", LegacyReportingUtils.getClassName((TestPlan)this.testPlan, (TestIdentifier)id));
        Duration maybeDuration = test.getDuration();
        boolean wasInterrupted = maybeDuration == null;
        Duration duration = maybeDuration == null ? Duration.between(test.getStarted(), Instant.now()) : maybeDuration;
        xml.writeAttribute("time", decimalFormat.format((float)duration.toMillis() / 1000.0f));
        if (wasInterrupted) {
            xml.writeStartElement("failure");
            xml.writeCData("Test timed out and was interrupted");
            xml.writeEndElement();
        } else {
            if (test.isDisabled() || test.isSkipped()) {
                xml.writeStartElement("skipped");
                if (test.getSkipReason() != null) {
                    xml.writeCData(test.getSkipReason());
                } else {
                    this.writeThrowableMessage(xml, test.getResult());
                }
                xml.writeEndElement();
            }
            if (test.isFailure() || test.isError()) {
                xml.writeStartElement(test.isFailure() ? "failure" : "error");
                this.writeThrowableMessage(xml, test.getResult());
                xml.writeEndElement();
            }
        }
        SafeXml.writeTextElement(xml, "system-out", test.getStdOut());
        SafeXml.writeTextElement(xml, "system-err", test.getStdErr());
        xml.writeEndElement();
    }

    private void writeThrowableMessage(XMLStreamWriter xml, TestExecutionResult result) throws XMLStreamException {
        Throwable throwable = null;
        if (result != null) {
            throwable = result.getThrowable().orElse(null);
        }
        if (throwable == null) {
            xml.writeAttribute("message", "unknown cause");
            xml.writeAttribute("type", RuntimeException.class.getName());
            return;
        }
        xml.writeAttribute("message", SafeXml.escapeIllegalCharacters(String.valueOf(throwable.getMessage())));
        xml.writeAttribute("type", throwable.getClass().getName());
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        SafeXml.writeCData(xml, stringWriter.toString());
    }
}

