/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tests;

import com.intellij.tests.IgnoreException;
import com.intellij.tests.Retries;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import jetbrains.buildServer.messages.serviceMessages.MapSerializerUtil;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import junit.framework.JUnit4TestAdapter;
import junit.framework.JUnit4TestAdapterCache;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.discovery.ClassNameFilter;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.PostDiscoveryFilter;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherConfig;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.opentest4j.AssertionFailedError;
import org.opentest4j.MultipleFailuresError;

public final class JUnit5TeamCityRunnerForTestAllSuite {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws ClassNotFoundException {
        if (args.length != 1 && args.length != 2) {
            System.err.printf("Expected one or two arguments, got %d: %s%n", args.length, Arrays.toString(args));
            System.exit(1);
        }
        try {
            List<ClassSelector> selectors;
            Launcher launcher = LauncherFactory.create((LauncherConfig)LauncherConfig.builder().enableLauncherSessionListenerAutoRegistration(false).build());
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            ArrayList<Object> filters = new ArrayList<Object>(0);
            if (args.length == 1) {
                selectors = Collections.singletonList(DiscoverySelectors.selectClass((String)args[0]));
            } else if (args[0].equals("__package__")) {
                selectors = Collections.singletonList(DiscoverySelectors.selectPackage((String)args[1]));
                filters.add(ClassNameFilter.excludeClassNamePatterns((String[])new String[]{"\\Q" + args[1] + "\\E\\.[^.]+\\..*"}));
            } else if (args[0].equals("__classes__")) {
                String[] classes = args[1].split(";");
                selectors = Arrays.stream(classes).map(DiscoverySelectors::selectClass).toList();
            } else {
                selectors = Collections.singletonList(DiscoverySelectors.selectMethod((String)args[0], (String)args[1]));
            }
            if (Boolean.getBoolean("idea.performance.tests.discovery.filter")) {
                filters.add(JUnit5TeamCityRunnerForTestAllSuite.createPerformancePostDiscoveryFilter(classLoader));
            }
            LauncherDiscoveryRequest discoveryRequest = LauncherDiscoveryRequestBuilder.request().selectors(selectors).filters(filters.toArray(new Filter[0])).build();
            TCExecutionListener listener = new TCExecutionListener();
            TestPlan testPlan = launcher.discover(discoveryRequest);
            launcher.execute(testPlan, new TestExecutionListener[]{listener});
            if (!listener.smthExecuted()) {
                System.exit(42);
            }
        }
        catch (Throwable x) {
            x.printStackTrace();
        }
        finally {
            System.exit(0);
        }
    }

    private static PostDiscoveryFilter createPerformancePostDiscoveryFilter(ClassLoader classLoader) throws NoSuchMethodException, ClassNotFoundException, IllegalAccessException {
        final MethodHandle method = MethodHandles.publicLookup().findStatic(Class.forName("com.intellij.testFramework.TestFrameworkUtil", true, classLoader), "isPerformanceTest", MethodType.methodType(Boolean.TYPE, String.class, String.class));
        return new PostDiscoveryFilter(){

            private FilterResult isIncluded(String className, String methodName) {
                try {
                    if (method.invokeExact(methodName, className)) {
                        return FilterResult.included(null);
                    }
                    return FilterResult.excluded(null);
                }
                catch (Throwable e) {
                    return FilterResult.excluded((String)e.getMessage());
                }
            }

            public FilterResult apply(TestDescriptor descriptor) {
                if (descriptor instanceof EngineDescriptor) {
                    return FilterResult.included(null);
                }
                TestSource source = descriptor.getSource().orElse(null);
                if (source == null) {
                    return FilterResult.included((String)"No source for descriptor");
                }
                if (source instanceof MethodSource) {
                    MethodSource methodSource = (MethodSource)source;
                    return this.isIncluded(methodSource.getClassName(), methodSource.getMethodName());
                }
                if (source instanceof ClassSource) {
                    ClassSource classSource = (ClassSource)source;
                    return this.isIncluded(classSource.getClassName(), null);
                }
                return FilterResult.included((String)("Unknown source type " + String.valueOf(source.getClass())));
            }
        };
    }

    public static JUnit4TestAdapterCache createJUnit4TestAdapterCache() {
        return new JUnit4TestAdapterCache(){

            public RunNotifier getNotifier(final TestResult result, JUnit4TestAdapter adapter) {
                RunNotifier notifier = new RunNotifier();
                notifier.addListener(new RunListener(){

                    public void testFailure(Failure failure) {
                        result.addError(this.asTest(failure.getDescription()), failure.getException());
                    }

                    public void testFinished(Description description) {
                        result.endTest(this.asTest(description));
                    }

                    public void testStarted(Description description) {
                        result.startTest(this.asTest(description));
                    }

                    public void testIgnored(Description description) {
                        result.addError(this.asTest(description), (Throwable)IgnoreException.INSTANCE);
                    }

                    public void testAssumptionFailure(Failure failure) {
                        this.testFailure(failure);
                    }
                });
                return notifier;
            }
        };
    }

    public static class TCExecutionListener
    implements TestExecutionListener {
        private static final String CLASS_CONFIGURATION = "Class Configuration";
        private final PrintStream myPrintStream = System.out;
        private TestPlan myTestPlan;
        private long myCurrentTestStart = 0L;
        private int myFinishCount = 0;
        private static final int MAX_STACKTRACE_MESSAGE_LENGTH = Integer.getInteger("intellij.build.test.stacktrace.max.length", 102400);
        private static final boolean CAPTURE_STANDARD_OUTPUT = !"false".equalsIgnoreCase(System.getProperty("intellij.build.test.captureStandardOutput"));

        public TCExecutionListener() {
            this.myPrintStream.println("##teamcity[enteredTheMatrix]");
        }

        public boolean smthExecuted() {
            return this.myCurrentTestStart != 0L;
        }

        public void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry entry) {
            StringBuilder builder = new StringBuilder();
            builder.append("timestamp = ").append(entry.getTimestamp());
            entry.getKeyValuePairs().forEach((key, value2) -> builder.append(", ").append((String)key).append(" = ").append((String)value2));
            builder.append("\n");
            this.myPrintStream.println("##teamcity[testStdOut" + this.idAndName(testIdentifier) + " out = '" + TCExecutionListener.escapeName(builder.toString()) + "']");
        }

        public void testPlanExecutionStarted(TestPlan testPlan) {
            this.myTestPlan = testPlan;
        }

        public void executionSkipped(TestIdentifier testIdentifier, String reason) {
            this.executionStarted(testIdentifier);
            this.executionFinished(testIdentifier, TestExecutionResult.Status.ABORTED, null, reason);
        }

        public void executionStarted(TestIdentifier testIdentifier) {
            if (testIdentifier.isTest()) {
                this.testStarted(testIdentifier);
                this.myCurrentTestStart = System.nanoTime();
            } else if (TCExecutionListener.hasNonTrivialParent(testIdentifier)) {
                this.myFinishCount = 0;
                this.myPrintStream.println("##teamcity[testSuiteStarted" + this.idAndName(testIdentifier) + "]");
            }
        }

        public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
            Throwable throwable = testExecutionResult.getThrowable().orElse(null);
            if (throwable != null && IgnoreException.isIgnoringThrowable(throwable)) {
                String message = throwable.getMessage();
                this.executionFinished(testIdentifier, TestExecutionResult.Status.ABORTED, null, message != null ? message : "");
            } else if (Retries.NUMBER > 0 && testIdentifier.isTest() && Retries.getAndClearSuccessfulStatus(testIdentifier)) {
                this.executionFinished(testIdentifier, TestExecutionResult.Status.SUCCESSFUL, null, null);
            } else {
                this.executionFinished(testIdentifier, testExecutionResult.getStatus(), throwable, null);
            }
        }

        private void executionFinished(TestIdentifier testIdentifier, TestExecutionResult.Status status, Throwable throwableOptional, String reason) {
            if (testIdentifier.isTest()) {
                long duration = this.getDuration();
                if (status == TestExecutionResult.Status.FAILED) {
                    this.testFailure(testIdentifier, "testFailed", throwableOptional, duration, reason);
                } else if (status == TestExecutionResult.Status.ABORTED) {
                    this.testFailure(testIdentifier, "testIgnored", throwableOptional, duration, reason);
                }
                this.testFinished(testIdentifier, duration);
                ++this.myFinishCount;
            } else if (TCExecutionListener.hasNonTrivialParent(testIdentifier)) {
                String messageName = null;
                if (status == TestExecutionResult.Status.FAILED) {
                    messageName = "testFailed";
                } else if (status == TestExecutionResult.Status.ABORTED) {
                    messageName = "testIgnored";
                }
                if (messageName != null) {
                    Set descendants;
                    if (status == TestExecutionResult.Status.FAILED) {
                        String parentId = this.getParentId(testIdentifier);
                        String nameAndId = " name='Class Configuration' nodeId='" + TCExecutionListener.escapeName(TCExecutionListener.getId(testIdentifier)) + "' parentNodeId='" + TCExecutionListener.escapeName(parentId) + "'";
                        this.myPrintStream.println("##teamcity[testStarted" + nameAndId + "]");
                        this.testFailure(CLASS_CONFIGURATION, TCExecutionListener.getId(testIdentifier), parentId, messageName, throwableOptional, 0L, reason);
                        this.myPrintStream.println("##teamcity[testFinished" + nameAndId + "]");
                    }
                    Set set = descendants = this.myTestPlan != null ? this.myTestPlan.getDescendants(testIdentifier) : Collections.emptySet();
                    if (!descendants.isEmpty() && this.myFinishCount == 0) {
                        for (TestIdentifier childIdentifier : descendants) {
                            this.testStarted(childIdentifier);
                            this.testFailure(childIdentifier, "testIgnored", status == TestExecutionResult.Status.ABORTED ? throwableOptional : null, 0L, reason);
                            this.testFinished(childIdentifier, 0L);
                        }
                        this.myFinishCount = 0;
                    }
                }
                this.myPrintStream.println("##teamcity[testSuiteFinished" + this.idAndName(testIdentifier) + "]");
            }
        }

        private static boolean hasNonTrivialParent(TestIdentifier testIdentifier) {
            return testIdentifier.getParentId().isPresent();
        }

        protected long getDuration() {
            return (System.nanoTime() - this.myCurrentTestStart) / 1000000L;
        }

        private void testStarted(TestIdentifier testIdentifier) {
            this.myPrintStream.println("##teamcity[testStarted" + this.idAndName(testIdentifier) + " captureStandardOutput='" + CAPTURE_STANDARD_OUTPUT + "']");
        }

        private void testFinished(TestIdentifier testIdentifier, long duration) {
            this.myPrintStream.println("##teamcity[testFinished" + this.idAndName(testIdentifier) + (String)(duration > 0L ? " duration='" + duration + "'" : "") + "]");
        }

        private void testFailure(TestIdentifier testIdentifier, String messageName, Throwable ex, long duration, String reason) {
            this.testFailure(TCExecutionListener.getName(testIdentifier), TCExecutionListener.getId(testIdentifier), this.getParentId(testIdentifier), messageName, ex, duration, reason);
        }

        private static String getName(TestIdentifier testIdentifier) {
            String displayName = testIdentifier.getDisplayName();
            return testIdentifier.getSource().map(s -> {
                if (s instanceof ClassSource) {
                    String className = ((ClassSource)s).getClassName();
                    if (className.equals(TestSuite.class.getName()) || className.equals(displayName)) {
                        return displayName;
                    }
                    String withDisplayName = "." + displayName;
                    return className.endsWith(withDisplayName) ? className : className + withDisplayName;
                }
                return s instanceof MethodSource ? ((MethodSource)s).getClassName() + "." + displayName : null;
            }).orElse(displayName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void testFailure(String methodName, String id, String parentId, String messageName, Throwable ex, long duration, String reason) {
            LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
            try {
                attrs.put("name", methodName);
                attrs.put("id", id);
                attrs.put("nodeId", id);
                attrs.put("parentNodeId", parentId);
                if (duration > 0L) {
                    attrs.put("duration", Long.toString(duration));
                }
                if (reason != null) {
                    attrs.put("message", TCExecutionListener.limit(reason));
                }
                if (ex != null) {
                    attrs.put("details", TCExecutionListener.getTrace(ex, MAX_STACKTRACE_MESSAGE_LENGTH));
                }
                if (ex != null) {
                    if (ex instanceof MultipleFailuresError && ((MultipleFailuresError)ex).hasFailures()) {
                        for (Throwable assertionError : ((MultipleFailuresError)ex).getFailures()) {
                            this.testFailure(methodName, id, parentId, messageName, assertionError, duration, reason);
                        }
                    } else if (ex instanceof AssertionFailedError && ((AssertionFailedError)ex).isActualDefined() && ((AssertionFailedError)ex).isExpectedDefined()) {
                        attrs.put("expected", TCExecutionListener.limit(((AssertionFailedError)ex).getExpected().getStringRepresentation()));
                        attrs.put("actual", TCExecutionListener.limit(((AssertionFailedError)ex).getActual().getStringRepresentation()));
                        attrs.put("type", "comparisonFailure");
                    } else {
                        Class<?> aClass = ex.getClass();
                        if (TCExecutionListener.isComparisonFailure(aClass)) {
                            try {
                                String expected = (String)aClass.getMethod("getExpected", new Class[0]).invoke((Object)ex, new Object[0]);
                                String actual = (String)aClass.getMethod("getActual", new Class[0]).invoke((Object)ex, new Object[0]);
                                attrs.put("expected", TCExecutionListener.limit(expected));
                                attrs.put("actual", TCExecutionListener.limit(actual));
                                attrs.put("type", "comparisonFailure");
                            }
                            catch (Throwable e) {
                                e.printStackTrace(this.myPrintStream);
                            }
                        }
                    }
                }
            }
            finally {
                this.myPrintStream.println(ServiceMessage.asString((String)messageName, attrs));
            }
        }

        private static boolean isComparisonFailure(Class<?> aClass) {
            if (aClass == null) {
                return false;
            }
            String throwableClassName = aClass.getName();
            if (throwableClassName.equals("junit.framework.ComparisonFailure") || throwableClassName.equals("org.junit.ComparisonFailure")) {
                return true;
            }
            return TCExecutionListener.isComparisonFailure(aClass.getSuperclass());
        }

        private static String limit(String string) {
            if (string == null) {
                return null;
            }
            if (string.length() > MAX_STACKTRACE_MESSAGE_LENGTH) {
                return string.substring(0, MAX_STACKTRACE_MESSAGE_LENGTH);
            }
            return string;
        }

        protected static String getTrace(Throwable ex, int limit) {
            StringWriter stringWriter = new StringWriter();
            LimitedStackTracePrintWriter writer = new LimitedStackTracePrintWriter(stringWriter, limit);
            ex.printStackTrace(writer);
            writer.close();
            return stringWriter.toString();
        }

        private static String getId(TestIdentifier identifier) {
            return identifier.getUniqueId();
        }

        private String idAndName(TestIdentifier testIdentifier) {
            String id = TCExecutionListener.getId(testIdentifier);
            String name = TCExecutionListener.getName(testIdentifier);
            String parentId = this.getParentId(testIdentifier);
            return " id='" + TCExecutionListener.escapeName(id) + "' name='" + TCExecutionListener.escapeName(name) + "' nodeId='" + TCExecutionListener.escapeName(id) + "' parentNodeId='" + TCExecutionListener.escapeName(parentId) + "'";
        }

        private String getParentId(TestIdentifier testIdentifier) {
            Optional parent = this.myTestPlan.getParent(testIdentifier);
            return parent.map(identifier -> identifier.getUniqueId()).orElse("0");
        }

        private static String escapeName(String str) {
            return MapSerializerUtil.escapeStr((String)str, (MapSerializerUtil.EscapeInfoProvider2)MapSerializerUtil.STD_ESCAPER2);
        }

        static class LimitedStackTracePrintWriter
        extends PrintWriter {
            public static final String CAUSED_BY = "Caused by: ";
            private final int headLimit;
            private final int tailLimit;
            private final List<String> tailLines = new ArrayList<String>(0);
            private boolean newLine = false;
            private boolean inCausedBy = false;
            private int headLength = 0;
            private int tailLength = 0;

            LimitedStackTracePrintWriter(StringWriter out, int limit) {
                super(out);
                this.tailLimit = limit / 10;
                this.headLimit = limit - this.tailLimit;
            }

            @Override
            public void print(String x) {
                int tailLeft;
                if (x == null) {
                    return;
                }
                int headLeft = this.headLimit - this.headLength;
                if (headLeft > 0) {
                    if (x.length() >= headLeft) {
                        x = x.substring(0, headLeft - 1);
                    }
                    super.print(x);
                    this.headLength += x.length();
                    this.newLine = true;
                    return;
                }
                if (x.contains(CAUSED_BY)) {
                    this.tailLines.clear();
                    this.tailLength = 0;
                    this.inCausedBy = true;
                }
                if (this.inCausedBy && (tailLeft = this.tailLimit - this.tailLength) > 0) {
                    if (x.length() >= tailLeft) {
                        x = x.substring(0, tailLeft + 1);
                    }
                    this.tailLines.add(x);
                    this.tailLength += x.length() + 1;
                }
            }

            @Override
            public void println() {
                if (this.newLine) {
                    this.newLine = false;
                    super.println();
                    ++this.headLength;
                }
            }

            private void finish() {
                if (!this.tailLines.isEmpty()) {
                    super.print("...");
                    super.println();
                    for (String line : this.tailLines) {
                        super.print(line);
                        super.println();
                    }
                    this.tailLines.clear();
                }
                super.flush();
            }

            @Override
            public void close() {
                this.finish();
                super.close();
            }
        }
    }
}

