/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.resources.api.share;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import joptsimple.internal.Strings;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.DocRequest;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.rest.RestRequest;
import org.opensearch.security.resources.ResourcePluginInfo;
import org.opensearch.security.spi.resources.sharing.ShareWith;

public class ShareRequest
extends ActionRequest
implements DocRequest {
    @JsonProperty(value="resource_id")
    private final String resourceId;
    @JsonProperty(value="resource_type")
    private final String resourceIndex;
    @JsonProperty(value="share_with")
    private final ShareWith shareWith;
    @JsonProperty(value="add")
    private final ShareWith add;
    @JsonProperty(value="revoke")
    private final ShareWith revoke;
    private final String resourceType;
    private final RestRequest.Method method;

    private ShareRequest(Builder builder) {
        this.resourceId = builder.resourceId;
        this.resourceIndex = builder.resourceIndex;
        this.shareWith = builder.shareWith;
        this.add = builder.add;
        this.revoke = builder.revoke;
        this.method = builder.method;
        this.resourceType = builder.resourceType;
    }

    public ShareRequest(StreamInput in) throws IOException {
        super(in);
        this.method = (RestRequest.Method)in.readEnum(RestRequest.Method.class);
        this.resourceId = in.readString();
        this.resourceIndex = in.readString();
        this.resourceType = in.readString();
        this.shareWith = (ShareWith)in.readOptionalWriteable(ShareWith::new);
        this.add = (ShareWith)in.readOptionalWriteable(ShareWith::new);
        this.revoke = (ShareWith)in.readOptionalWriteable(ShareWith::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this.method);
        out.writeString(this.resourceId);
        out.writeString(this.resourceIndex);
        out.writeString(this.resourceType);
        out.writeOptionalWriteable((Writeable)this.shareWith);
        out.writeOptionalWriteable((Writeable)this.add);
        out.writeOptionalWriteable((Writeable)this.revoke);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException arv = new ActionRequestValidationException();
        if (Strings.isNullOrEmpty((String)this.resourceIndex) || Strings.isNullOrEmpty((String)this.resourceId)) {
            arv.addValidationError("resource_id and resource_type must be present");
            throw arv;
        }
        if (this.method == RestRequest.Method.GET) {
            return null;
        }
        if (this.shareWith == null && this.method == RestRequest.Method.PUT) {
            arv.addValidationError("share_with is required");
            throw arv;
        }
        if (this.method == RestRequest.Method.PATCH && this.add == null && this.revoke == null) {
            arv.addValidationError("either add or revoke must be present");
            throw arv;
        }
        return null;
    }

    public ShareWith getShareWith() {
        return this.shareWith;
    }

    public ShareWith getAdd() {
        return this.add;
    }

    public ShareWith getRevoke() {
        return this.revoke;
    }

    public RestRequest.Method getMethod() {
        return this.method;
    }

    public String type() {
        return this.resourceType;
    }

    public String index() {
        return this.resourceIndex;
    }

    public String id() {
        return this.resourceId;
    }

    public static class Builder {
        private String resourceId;
        private String resourceIndex;
        private String resourceType;
        private ShareWith shareWith;
        private ShareWith add;
        private ShareWith revoke;
        private RestRequest.Method method;

        public void resourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public void resourceIndex(String resourceIndex) {
            this.resourceIndex = resourceIndex;
        }

        public void resourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public void shareWith(ShareWith shareWith) {
            this.shareWith = shareWith;
        }

        public void add(ShareWith add) {
            this.add = add;
        }

        public void revoke(ShareWith revoke) {
            this.revoke = revoke;
        }

        public void method(RestRequest.Method method) {
            this.method = method;
        }

        public ShareRequest build() {
            return new ShareRequest(this);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void parseContent(XContentParser xContentParser, ResourcePluginInfo resourcePluginInfo) throws IOException {
            try (XContentParser parser = xContentParser;){
                XContentParser.Token token;
                block19: while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token != XContentParser.Token.FIELD_NAME) continue;
                    String name = parser.currentName();
                    parser.nextToken();
                    switch (name) {
                        case "resource_id": {
                            this.resourceId(parser.text());
                            continue block19;
                        }
                        case "resource_type": {
                            this.resourceType(parser.text());
                            this.resourceIndex(resourcePluginInfo.indexByType(parser.text()));
                            continue block19;
                        }
                        case "share_with": {
                            this.shareWith(ShareWith.fromXContent((XContentParser)parser));
                            continue block19;
                        }
                        case "add": {
                            this.add(ShareWith.fromXContent((XContentParser)parser));
                            continue block19;
                        }
                        case "revoke": {
                            this.revoke(ShareWith.fromXContent((XContentParser)parser));
                            continue block19;
                        }
                    }
                    parser.skipChildren();
                }
                return;
            }
        }
    }
}

