/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiExceptions;
import com.google.api.gax.rpc.ClientStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.BlobWriteSessionConfig;
import com.google.cloud.storage.BlobWriteSessionConfigs;
import com.google.cloud.storage.BufferHandle;
import com.google.cloud.storage.BufferedWritableByteChannelSession;
import com.google.cloud.storage.ByteStringStrategy;
import com.google.cloud.storage.Conversions;
import com.google.cloud.storage.CrossTransportUtils;
import com.google.cloud.storage.GrpcStorageImpl;
import com.google.cloud.storage.RecoveryFile;
import com.google.cloud.storage.RecoveryFileManager;
import com.google.cloud.storage.ResumableMedia;
import com.google.cloud.storage.ResumableWrite;
import com.google.cloud.storage.StorageInternal;
import com.google.cloud.storage.ThroughputMovingWindow;
import com.google.cloud.storage.ThroughputSink;
import com.google.cloud.storage.TransportCompatibility;
import com.google.cloud.storage.UnifiedOpts;
import com.google.cloud.storage.WritableByteChannelSession;
import com.google.cloud.storage.WriteCtx;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.storage.v2.QueryWriteStatusRequest;
import com.google.storage.v2.QueryWriteStatusResponse;
import com.google.storage.v2.WriteObjectRequest;
import com.google.storage.v2.WriteObjectResponse;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.stream.Collector;
import javax.annotation.concurrent.Immutable;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@BetaApi
@TransportCompatibility(value={TransportCompatibility.Transport.GRPC})
@Immutable
public final class JournalingBlobWriteSessionConfig
extends BlobWriteSessionConfig
implements BlobWriteSessionConfig.GrpcCompatible {
    private static final long serialVersionUID = 9059242302276891867L;
    private transient @MonotonicNonNull ImmutableList<Path> paths;
    private final boolean includeLoggingSink;
    private volatile @MonotonicNonNull ArrayList<String> absolutePaths;

    @InternalApi
    JournalingBlobWriteSessionConfig(ImmutableList<Path> paths, boolean includeLoggingSink) {
        this.paths = paths;
        this.includeLoggingSink = includeLoggingSink;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JournalingBlobWriteSessionConfig)) {
            return false;
        }
        JournalingBlobWriteSessionConfig that = (JournalingBlobWriteSessionConfig)o;
        return this.includeLoggingSink == that.includeLoggingSink && Objects.equals(this.paths, that.paths) && Objects.equals(this.absolutePaths, that.absolutePaths);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.paths, this.includeLoggingSink, this.absolutePaths);
    }

    @InternalApi
    @VisibleForTesting
    JournalingBlobWriteSessionConfig withIncludeLoggingSink() {
        return new JournalingBlobWriteSessionConfig(this.paths, true);
    }

    @Override
    @InternalApi
    BlobWriteSessionConfig.WriterFactory createFactory(Clock clock) throws IOException {
        Duration window = Duration.ofMinutes(10L);
        RecoveryFileManager recoveryFileManager = RecoveryFileManager.of(this.paths, this.getRecoverVolumeSinkFactory(clock, window));
        ThroughputSink gcs = ThroughputSink.windowed(ThroughputMovingWindow.of(window), clock);
        gcs = this.includeLoggingSink ? ThroughputSink.tee(ThroughputSink.logged("gcs", clock), gcs) : gcs;
        return new Factory(recoveryFileManager, clock, gcs);
    }

    private RecoveryFileManager.RecoveryVolumeSinkFactory getRecoverVolumeSinkFactory(Clock clock, Duration window) {
        return path -> {
            ThroughputSink windowed = ThroughputSink.windowed(ThroughputMovingWindow.of(window), clock);
            if (this.includeLoggingSink) {
                return ThroughputSink.tee(ThroughputSink.logged(path.toAbsolutePath().toString(), clock), windowed);
            }
            return windowed;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.absolutePaths == null) {
            JournalingBlobWriteSessionConfig journalingBlobWriteSessionConfig = this;
            synchronized (journalingBlobWriteSessionConfig) {
                if (this.absolutePaths == null) {
                    this.absolutePaths = this.paths.stream().map(Path::toAbsolutePath).map(Path::toString).collect(Collector.of(ArrayList::new, ArrayList::add, (left, right) -> {
                        left.addAll(right);
                        return left;
                    }, new Collector.Characteristics[0]));
                }
            }
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.paths = (ImmutableList)this.absolutePaths.stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(ImmutableList.toImmutableList());
    }

    private static final class Factory
    implements BlobWriteSessionConfig.WriterFactory {
        private final RecoveryFileManager recoveryFileManager;
        private final Clock clock;
        private final ThroughputSink gcs;

        private Factory(RecoveryFileManager recoveryFileManager, Clock clock, ThroughputSink gcs) {
            this.recoveryFileManager = recoveryFileManager;
            this.clock = clock;
            this.gcs = gcs;
        }

        @Override
        @InternalApi
        public WritableByteChannelSession<?, BlobInfo> writeSession(StorageInternal storage, BlobInfo info, UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> opts) {
            if (storage instanceof GrpcStorageImpl) {
                GrpcStorageImpl grpcStorage = (GrpcStorageImpl)storage;
                RecoveryFile recoveryFile = this.recoveryFileManager.newRecoveryFile(info);
                GrpcCallContext grpcCallContext = opts.grpcMetadataMapper().apply(GrpcCallContext.createDefault());
                ApiFuture<ResumableWrite> f = grpcStorage.startResumableWrite(grpcCallContext, grpcStorage.getWriteObjectRequest(info, opts), opts);
                ApiFuture start = ApiFutures.transform(f, s -> WriteCtx.of(s, opts.getHasher()), (Executor)MoreExecutors.directExecutor());
                ClientStreamingCallable write = grpcStorage.storageClient.writeObjectCallable().withDefaultCallContext((ApiCallContext)grpcCallContext);
                BufferedWritableByteChannelSession<WriteObjectResponse> session = ResumableMedia.gapic().write().byteChannel((ClientStreamingCallable<WriteObjectRequest, WriteObjectResponse>)write).setHasher(opts.getHasher()).setByteStringStrategy(ByteStringStrategy.copy()).journaling().withRetryConfig(grpcStorage.retrier, grpcStorage.retryAlgorithmManager.idempotent(), (UnaryCallable<QueryWriteStatusRequest, QueryWriteStatusResponse>)grpcStorage.storageClient.queryWriteStatusCallable()).withBuffer(BufferHandle.allocate(0x200000)).withRecoveryBuffer(BufferHandle.allocate(0x200000)).withRecoveryFile(recoveryFile).setStartAsync((ApiFuture<WriteCtx<ResumableWrite>>)start).build();
                return new JournalingUpload(session, (ApiFuture<WriteCtx<ResumableWrite>>)start);
            }
            return (WritableByteChannelSession)CrossTransportUtils.throwGrpcOnly(BlobWriteSessionConfigs.class, "journaling");
        }

        private final class JournalingUpload<WBC extends WritableByteChannel>
        implements WritableByteChannelSession<WBC, BlobInfo> {
            private final WritableByteChannelSession<WBC, WriteObjectResponse> session;
            private final ApiFuture<WriteCtx<ResumableWrite>> start;
            private final Conversions.Decoder<WriteObjectResponse, BlobInfo> decoder;

            public JournalingUpload(WritableByteChannelSession<WBC, WriteObjectResponse> session, ApiFuture<WriteCtx<ResumableWrite>> start) {
                this.session = session;
                this.start = start;
                this.decoder = Conversions.grpc().blobInfo().compose(WriteObjectResponse::getResource);
            }

            @Override
            public ApiFuture<WBC> openAsync() {
                final Instant begin = Factory.this.clock.instant();
                ApiFutures.addCallback(this.session.getResult(), (ApiFutureCallback)new ApiFutureCallback<WriteObjectResponse>(){

                    public void onFailure(Throwable t) {
                        Instant end = Factory.this.clock.instant();
                        WriteCtx writeCtx = (WriteCtx)ApiExceptions.callAndTranslateApiException((ApiFuture)JournalingUpload.this.start);
                        long totalSentBytes = writeCtx.getTotalSentBytes().get();
                        Factory.this.gcs.recordThroughput(ThroughputSink.Record.of(totalSentBytes, begin, end, true));
                    }

                    public void onSuccess(WriteObjectResponse result) {
                        Instant end = Factory.this.clock.instant();
                        long totalSentBytes = -1L;
                        if (result.hasResource()) {
                            totalSentBytes = result.getResource().getSize();
                        } else if (result.hasPersistedSize()) {
                            totalSentBytes = result.getPersistedSize();
                        }
                        if (totalSentBytes > -1L) {
                            Factory.this.gcs.recordThroughput(ThroughputSink.Record.of(totalSentBytes, begin, end, false));
                        }
                    }
                }, (Executor)MoreExecutors.directExecutor());
                return this.session.openAsync();
            }

            @Override
            public ApiFuture<BlobInfo> getResult() {
                return ApiFutures.transform(this.session.getResult(), this.decoder::decode, (Executor)MoreExecutors.directExecutor());
            }
        }
    }
}

