/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.engine;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.suggest.document.CompletionTerms;
import org.opensearch.action.support.PlainActionFuture;
import org.opensearch.common.FieldMemoryStats;
import org.opensearch.common.Nullable;
import org.opensearch.common.regex.Regex;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.util.CollectionUtils;
import org.opensearch.index.engine.Engine;
import org.opensearch.search.suggest.completion.CompletionStats;

class CompletionStatsCache
implements ReferenceManager.RefreshListener {
    private final Supplier<Engine.Searcher> searcherSupplier;
    @Nullable
    private PlainActionFuture<CompletionStats> completionStatsFuture;
    private final Object completionStatsFutureMutex = new Object();

    CompletionStatsCache(Supplier<Engine.Searcher> searcherSupplier) {
        this.searcherSupplier = searcherSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletionStats get(String ... fieldNamePatterns) {
        CompletionStats completionStats;
        PlainActionFuture<CompletionStats> oldFuture;
        PlainActionFuture newFuture = new PlainActionFuture();
        Object object = this.completionStatsFutureMutex;
        synchronized (object) {
            if (this.completionStatsFuture == null) {
                this.completionStatsFuture = newFuture;
                oldFuture = null;
            } else {
                oldFuture = this.completionStatsFuture;
            }
        }
        if (oldFuture != null) {
            return CompletionStatsCache.filterCompletionStatsByFieldName(fieldNamePatterns, (CompletionStats)oldFuture.actionGet());
        }
        ActionListener.completeWith(newFuture, () -> {
            long sizeInBytes = 0L;
            HashMap<String, Long> completionFields = new HashMap<String, Long>();
            try (Engine.Searcher currentSearcher = this.searcherSupplier.get();){
                for (LeafReaderContext atomicReaderContext : currentSearcher.getIndexReader().leaves()) {
                    LeafReader atomicReader = atomicReaderContext.reader();
                    for (FieldInfo info : atomicReader.getFieldInfos()) {
                        Terms terms = atomicReader.terms(info.name);
                        if (!(terms instanceof CompletionTerms)) continue;
                        CompletionTerms completionTerms = (CompletionTerms)terms;
                        long fstSize = completionTerms.suggester().ramBytesUsed();
                        completionFields.merge(info.name, fstSize, Long::sum);
                        sizeInBytes += fstSize;
                    }
                }
            }
            return new CompletionStats.Builder().sizeInBytes(sizeInBytes).fieldMemoryStats(new FieldMemoryStats(completionFields)).build();
        });
        boolean success = false;
        try {
            completionStats = (CompletionStats)newFuture.actionGet();
            success = true;
        }
        finally {
            if (!success) {
                Object object2 = this.completionStatsFutureMutex;
                synchronized (object2) {
                    if (this.completionStatsFuture == newFuture) {
                        this.completionStatsFuture = null;
                    }
                }
            }
        }
        return CompletionStatsCache.filterCompletionStatsByFieldName(fieldNamePatterns, completionStats);
    }

    private static CompletionStats filterCompletionStatsByFieldName(String[] fieldNamePatterns, CompletionStats fullCompletionStats) {
        FieldMemoryStats fieldMemoryStats;
        if (!CollectionUtils.isEmpty((Object[])fieldNamePatterns)) {
            HashMap<String, Long> completionFields = new HashMap<String, Long>(fieldNamePatterns.length);
            for (Map.Entry<String, Long> fieldCursor : fullCompletionStats.getFields()) {
                if (!Regex.simpleMatch(fieldNamePatterns, fieldCursor.getKey())) continue;
                completionFields.merge(fieldCursor.getKey(), fieldCursor.getValue(), Long::sum);
            }
            fieldMemoryStats = new FieldMemoryStats(completionFields);
        } else {
            fieldMemoryStats = null;
        }
        return new CompletionStats.Builder().sizeInBytes(fullCompletionStats.getSizeInBytes()).fieldMemoryStats(fieldMemoryStats).build();
    }

    public void beforeRefresh() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterRefresh(boolean didRefresh) {
        if (didRefresh) {
            Object object = this.completionStatsFutureMutex;
            synchronized (object) {
                this.completionStatsFuture = null;
            }
        }
    }
}

