/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.LeafReader;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.mapper.FieldValueFetcher;
import org.opensearch.index.mapper.FieldValueType;
import org.opensearch.index.mapper.MappedFieldType;

public class DerivedFieldGenerator {
    private final MappedFieldType mappedFieldType;
    private final FieldValueFetcher fieldValueFetcher;

    public DerivedFieldGenerator(MappedFieldType mappedFieldType, FieldValueFetcher docValuesFetcher, FieldValueFetcher storedFieldFetcher) {
        this.mappedFieldType = mappedFieldType;
        if (Objects.requireNonNull(this.getDerivedFieldPreference()) == FieldValueType.DOC_VALUES) {
            assert (docValuesFetcher != null);
            this.fieldValueFetcher = docValuesFetcher;
        } else {
            assert (storedFieldFetcher != null);
            this.fieldValueFetcher = storedFieldFetcher;
        }
    }

    public FieldValueType getDerivedFieldPreference() {
        if (this.mappedFieldType.hasDocValues()) {
            return FieldValueType.DOC_VALUES;
        }
        return FieldValueType.STORED;
    }

    public void generate(XContentBuilder builder, LeafReader reader, int docId) throws IOException {
        this.fieldValueFetcher.write(builder, this.fieldValueFetcher.fetch(reader, docId));
    }
}

