/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.node.stats;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.opensearch.action.admin.indices.stats.CommonStatsFlags;
import org.opensearch.action.support.nodes.BaseNodesRequest;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

@PublicApi(since="1.0.0")
public class NodesStatsRequest
extends BaseNodesRequest<NodesStatsRequest> {
    private CommonStatsFlags indices = new CommonStatsFlags(new CommonStatsFlags.Flag[0]);
    private final Set<String> requestedMetrics = new HashSet<String>();

    public NodesStatsRequest() {
        super((String[])null);
    }

    public NodesStatsRequest(StreamInput in) throws IOException {
        super(in);
        this.indices = new CommonStatsFlags(in);
        this.requestedMetrics.clear();
        this.requestedMetrics.addAll(in.readStringList());
    }

    public NodesStatsRequest(String ... nodesIds) {
        super(nodesIds);
    }

    public NodesStatsRequest all() {
        this.indices.all();
        this.requestedMetrics.addAll(Metric.allMetrics());
        return this;
    }

    public NodesStatsRequest clear() {
        this.indices.clear();
        this.requestedMetrics.clear();
        return this;
    }

    public CommonStatsFlags indices() {
        return this.indices;
    }

    public NodesStatsRequest indices(CommonStatsFlags indices) {
        this.indices = indices;
        return this;
    }

    public NodesStatsRequest indices(boolean indices) {
        if (indices) {
            this.indices.all();
        } else {
            this.indices.clear();
        }
        return this;
    }

    public Set<String> requestedMetrics() {
        return new HashSet<String>(this.requestedMetrics);
    }

    public NodesStatsRequest addMetric(String metric) {
        if (!Metric.allMetrics().contains(metric)) {
            throw new IllegalStateException("Used an illegal metric: " + metric);
        }
        this.requestedMetrics.add(metric);
        return this;
    }

    public NodesStatsRequest addMetrics(String ... metrics) {
        TreeSet<String> metricsSet = new TreeSet<String>(Arrays.asList(metrics));
        if (!Metric.allMetrics().containsAll(metricsSet)) {
            metricsSet.removeAll(Metric.allMetrics());
            String plural = metricsSet.size() == 1 ? "" : "s";
            throw new IllegalStateException("Used illegal metric" + plural + ": " + String.valueOf(metricsSet));
        }
        this.requestedMetrics.addAll(metricsSet);
        return this;
    }

    public NodesStatsRequest removeMetric(String metric) {
        if (!Metric.allMetrics().contains(metric)) {
            throw new IllegalStateException("Used an illegal metric: " + metric);
        }
        this.requestedMetrics.remove(metric);
        return this;
    }

    private void optionallyAddMetric(boolean includeMetric, String metricName) {
        if (includeMetric) {
            this.requestedMetrics.add(metricName);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.indices.writeTo(out);
        out.writeStringArray(this.requestedMetrics.toArray(new String[0]));
    }

    public static enum Metric {
        OS("os"),
        PROCESS("process"),
        JVM("jvm"),
        THREAD_POOL("thread_pool"),
        FS("fs"),
        TRANSPORT("transport"),
        HTTP("http"),
        BREAKER("breaker"),
        SCRIPT("script"),
        DISCOVERY("discovery"),
        INGEST("ingest"),
        ADAPTIVE_SELECTION("adaptive_selection"),
        SCRIPT_CACHE("script_cache"),
        INDEXING_PRESSURE("indexing_pressure"),
        SHARD_INDEXING_PRESSURE("shard_indexing_pressure"),
        SEARCH_BACKPRESSURE("search_backpressure"),
        CLUSTER_MANAGER_THROTTLING("cluster_manager_throttling"),
        WEIGHTED_ROUTING_STATS("weighted_routing"),
        FILE_CACHE_STATS("file_cache"),
        TASK_CANCELLATION("task_cancellation"),
        SEARCH_PIPELINE("search_pipeline"),
        RESOURCE_USAGE_STATS("resource_usage_stats"),
        SEGMENT_REPLICATION_BACKPRESSURE("segment_replication_backpressure"),
        REPOSITORIES("repositories"),
        ADMISSION_CONTROL("admission_control"),
        CACHE_STATS("caches"),
        REMOTE_STORE("remote_store");

        private String metricName;

        private Metric(String name) {
            this.metricName = name;
        }

        public String metricName() {
            return this.metricName;
        }

        boolean containedIn(Set<String> metricNames) {
            return metricNames.contains(this.metricName());
        }

        static Set<String> allMetrics() {
            return Arrays.stream(Metric.values()).map(Metric::metricName).collect(Collectors.toSet());
        }
    }
}

