/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc;

import io.grpc.BindableService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.network.NetworkService;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.indices.breaker.CircuitBreakerService;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.env.Environment;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.plugins.ExtensiblePlugin;
import org.opensearch.plugins.NetworkPlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.plugins.SecureAuxTransportSettingsProvider;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.script.ScriptService;
import org.opensearch.telemetry.tracing.Tracer;
import org.opensearch.threadpool.ExecutorBuilder;
import org.opensearch.threadpool.FixedExecutorBuilder;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.AuxTransport;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.grpc.Netty4GrpcServerTransport;
import org.opensearch.transport.grpc.proto.request.search.query.AbstractQueryBuilderProtoUtils;
import org.opensearch.transport.grpc.proto.request.search.query.QueryBuilderProtoConverterRegistryImpl;
import org.opensearch.transport.grpc.services.DocumentServiceImpl;
import org.opensearch.transport.grpc.services.SearchServiceImpl;
import org.opensearch.transport.grpc.spi.QueryBuilderProtoConverter;
import org.opensearch.transport.grpc.spi.QueryBuilderProtoConverterRegistry;
import org.opensearch.transport.grpc.ssl.SecureNetty4GrpcServerTransport;
import org.opensearch.watcher.ResourceWatcherService;

public final class GrpcPlugin
extends Plugin
implements NetworkPlugin,
ExtensiblePlugin {
    private static final Logger logger = LogManager.getLogger(GrpcPlugin.class);
    public static final String GRPC_THREAD_POOL_NAME = "grpc";
    private Client client;
    private final List<QueryBuilderProtoConverter> queryConverters = new ArrayList<QueryBuilderProtoConverter>();
    private QueryBuilderProtoConverterRegistryImpl queryRegistry;
    private AbstractQueryBuilderProtoUtils queryUtils;

    public void loadExtensions(ExtensiblePlugin.ExtensionLoader loader) {
        List extensions = loader.loadExtensions(QueryBuilderProtoConverter.class);
        if (extensions != null && !extensions.isEmpty()) {
            logger.info("Loading {} QueryBuilderProtoConverter extensions from other plugins", (Object)extensions.size());
            for (QueryBuilderProtoConverter converter : extensions) {
                logger.info("Discovered QueryBuilderProtoConverter extension: {} (handles: {})", (Object)converter.getClass().getName(), (Object)converter.getHandledQueryCase());
                this.queryConverters.add(converter);
            }
            logger.info("Successfully loaded {} QueryBuilderProtoConverter extensions", (Object)extensions.size());
        } else {
            logger.info("No QueryBuilderProtoConverter extensions found from other plugins");
        }
    }

    public List<QueryBuilderProtoConverter> getQueryConverters() {
        return Collections.unmodifiableList(this.queryConverters);
    }

    public AbstractQueryBuilderProtoUtils getQueryUtils() {
        if (this.queryUtils == null) {
            throw new IllegalStateException("Query utils not initialized. Make sure createComponents has been called.");
        }
        return this.queryUtils;
    }

    public Map<String, Supplier<AuxTransport>> getAuxTransports(Settings settings, ThreadPool threadPool, CircuitBreakerService circuitBreakerService, NetworkService networkService, ClusterSettings clusterSettings, Tracer tracer) {
        if (this.client == null) {
            throw new RuntimeException("client cannot be null");
        }
        if (this.queryRegistry == null) {
            throw new IllegalStateException("createComponents must be called before getAuxTransports to initialize the registry");
        }
        List<BindableService> grpcServices = this.registerGRPCServices(new BindableService[]{new DocumentServiceImpl(this.client), new SearchServiceImpl(this.client, this.queryUtils)});
        return Collections.singletonMap("transport-grpc", () -> new Netty4GrpcServerTransport(settings, grpcServices, networkService, threadPool));
    }

    public Map<String, Supplier<AuxTransport>> getSecureAuxTransports(Settings settings, ThreadPool threadPool, CircuitBreakerService circuitBreakerService, NetworkService networkService, ClusterSettings clusterSettings, SecureAuxTransportSettingsProvider secureAuxTransportSettingsProvider, Tracer tracer) {
        if (this.client == null) {
            throw new RuntimeException("client cannot be null");
        }
        if (this.queryRegistry == null) {
            throw new IllegalStateException("createComponents must be called before getSecureAuxTransports to initialize the registry");
        }
        List<BindableService> grpcServices = this.registerGRPCServices(new BindableService[]{new DocumentServiceImpl(this.client), new SearchServiceImpl(this.client, this.queryUtils)});
        return Collections.singletonMap("secure-transport-grpc", () -> new SecureNetty4GrpcServerTransport(settings, grpcServices, networkService, threadPool, secureAuxTransportSettingsProvider));
    }

    private List<BindableService> registerGRPCServices(BindableService ... services) {
        return List.of(services);
    }

    public List<Setting<?>> getSettings() {
        return List.of(Netty4GrpcServerTransport.SETTING_GRPC_PORT, Netty4GrpcServerTransport.SETTING_GRPC_PUBLISH_PORT, SecureNetty4GrpcServerTransport.SETTING_GRPC_SECURE_PORT, Netty4GrpcServerTransport.SETTING_GRPC_HOST, Netty4GrpcServerTransport.SETTING_GRPC_PUBLISH_HOST, Netty4GrpcServerTransport.SETTING_GRPC_BIND_HOST, Netty4GrpcServerTransport.SETTING_GRPC_WORKER_COUNT, Netty4GrpcServerTransport.SETTING_GRPC_EXECUTOR_COUNT, Netty4GrpcServerTransport.SETTING_GRPC_MAX_CONCURRENT_CONNECTION_CALLS, Netty4GrpcServerTransport.SETTING_GRPC_MAX_MSG_SIZE, Netty4GrpcServerTransport.SETTING_GRPC_MAX_CONNECTION_AGE, Netty4GrpcServerTransport.SETTING_GRPC_MAX_CONNECTION_IDLE, Netty4GrpcServerTransport.SETTING_GRPC_KEEPALIVE_TIMEOUT);
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        int executorCount = (Integer)Netty4GrpcServerTransport.SETTING_GRPC_EXECUTOR_COUNT.get(settings);
        return List.of(new FixedExecutorBuilder(settings, GRPC_THREAD_POOL_NAME, executorCount, 1000, "thread_pool.grpc"));
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        this.client = client;
        this.queryRegistry = new QueryBuilderProtoConverterRegistryImpl();
        this.queryUtils = new AbstractQueryBuilderProtoUtils(this.queryRegistry);
        if (!this.queryConverters.isEmpty()) {
            logger.info("Injecting registry and registering {} external QueryBuilderProtoConverter(s)", (Object)this.queryConverters.size());
            for (QueryBuilderProtoConverter converter : this.queryConverters) {
                logger.info("Processing external converter: {} (handles: {})", (Object)converter.getClass().getName(), (Object)converter.getHandledQueryCase());
                converter.setRegistry((QueryBuilderProtoConverterRegistry)this.queryRegistry);
                logger.info("Injected registry into converter: {}", (Object)converter.getClass().getName());
                this.queryRegistry.registerConverter(converter);
            }
            logger.info("Successfully injected registry and registered all {} external converters", (Object)this.queryConverters.size());
            this.queryRegistry.updateRegistryOnAllConverters();
            logger.info("Updated registry on all converters to include external converters");
        } else {
            logger.info("No external QueryBuilderProtoConverter(s) to register");
        }
        return super.createComponents(client, clusterService, threadPool, resourceWatcherService, scriptService, xContentRegistry, environment, nodeEnvironment, namedWriteableRegistry, indexNameExpressionResolver, repositoriesServiceSupplier);
    }
}

