from typing import Optional

from pydantic import BaseModel
from sqlalchemy import Column, Integer, String, Double, ForeignKey
from sqlalchemy.orm import relationship

from ..base import Base


class ThreadTime(Base):
    __tablename__ = 'thread_time'
    id = Column(Integer, primary_key=True, index=True)
    name = Column(String)
    time_ms = Column(Double)
    utilisation_pct = Column(Double)
    report_id = Column(Integer, ForeignKey('report.id'))
    report = relationship('Report', back_populates='thread_time')
    utilisation_p_core_pct = Column(Double, nullable=True)
    utilisation_e_core_pct = Column(Double, nullable=True)


class ThreadTimeInDB(BaseModel):
    id: int
    name: str
    time_ms: float
    utilisation_pct: float
    utilisation_p_core_pct: Optional[float]
    utilisation_e_core_pct: Optional[float]

    class Config:
        from_attributes = True


class ThreadTimeCreate(BaseModel):
    name: str
    time_ms: float
    utilisation_pct: float
    utilisation_p_core_pct: Optional[float]
    utilisation_e_core_pct: Optional[float]
