/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.ffprobe;

import com.github.kokorin.jaffree.Rational;
import com.github.kokorin.jaffree.StreamType;
import com.github.kokorin.jaffree.ffprobe.SideData;
import com.github.kokorin.jaffree.ffprobe.StreamDisposition;
import com.github.kokorin.jaffree.ffprobe.TagAware;
import com.github.kokorin.jaffree.ffprobe.data.ProbeData;
import java.util.List;

public class Stream
implements TagAware {
    private final ProbeData probeData;

    public Stream(ProbeData probeData) {
        this.probeData = probeData;
    }

    @Override
    public ProbeData getProbeData() {
        return this.probeData;
    }

    public String getId() {
        return this.probeData.getString("id");
    }

    public Integer getIndex() {
        return this.probeData.getInteger("index");
    }

    public StreamDisposition getDisposition() {
        return new StreamDisposition(this.probeData.getSubData("disposition"));
    }

    public List<SideData> getSideDataList() {
        return this.probeData.getSubDataList("side_data_list", SideData::new);
    }

    public String getCodecName() {
        return this.probeData.getString("codec_name");
    }

    public String getCodecLongName() {
        return this.probeData.getString("codec_long_name");
    }

    public String getProfile() {
        return this.probeData.getString("profile");
    }

    public Integer getLevel() {
        return this.probeData.getInteger("level");
    }

    public StreamType getCodecType() {
        return this.probeData.getStreamType("codec_type");
    }

    @Deprecated
    public Rational getCodecTimeBase() {
        return this.probeData.getRational("codec_time_base");
    }

    public String getCodecTag() {
        return this.probeData.getString("codec_tag");
    }

    public String getCodecTagString() {
        return this.probeData.getString("codec_tag_string");
    }

    public String getExtradata() {
        return this.probeData.getString("extradata");
    }

    public String getExtradataHash() {
        return this.probeData.getString("extradata_hash");
    }

    public Integer getWidth() {
        return this.probeData.getInteger("width");
    }

    public Integer getHeight() {
        return this.probeData.getInteger("height");
    }

    public Integer getCodedWidth() {
        return this.probeData.getInteger("coded_width");
    }

    public Integer getCodedHeight() {
        return this.probeData.getInteger("coded_height");
    }

    public Integer hasBFrames() {
        return this.probeData.getInteger("has_b_frames");
    }

    public Rational getSampleAspectRatio() {
        return this.probeData.getRatio("sample_aspect_ratio");
    }

    public Rational getDisplayAspectRatio() {
        return this.probeData.getRatio("display_aspect_ratio");
    }

    public String getPixFmt() {
        return this.probeData.getString("pix_fmt");
    }

    public String getColorRange() {
        return this.probeData.getString("color_range");
    }

    public String getColorSpace() {
        return this.probeData.getString("color_space");
    }

    public String getColorTransfer() {
        return this.probeData.getString("color_transfer");
    }

    public String getColorPrimaries() {
        return this.probeData.getString("color_primaries");
    }

    public String getChromaLocation() {
        return this.probeData.getString("chroma_location");
    }

    public String getFieldOrder() {
        return this.probeData.getString("field_order");
    }

    @Deprecated
    public String getTimecode() {
        return this.probeData.getString("timecode");
    }

    public Integer getRefs() {
        return this.probeData.getInteger("refs");
    }

    public String getSampleFmt() {
        return this.probeData.getString("sample_fmt");
    }

    public Integer getSampleRate() {
        return this.probeData.getInteger("sample_rate");
    }

    public Integer getChannels() {
        return this.probeData.getInteger("channels");
    }

    public String getChannelLayout() {
        return this.probeData.getString("channel_layout");
    }

    public Integer getBitsPerSample() {
        return this.probeData.getInteger("bits_per_sample");
    }

    public Rational getRFrameRate() {
        return this.probeData.getRational("r_frame_rate");
    }

    public Rational getAvgFrameRate() {
        return this.probeData.getRational("avg_frame_rate");
    }

    public String getTimeBase() {
        return this.probeData.getString("time_base");
    }

    public Long getStartPts() {
        return this.probeData.getLong("start_pts");
    }

    public Float getStartTime() {
        return this.probeData.getFloat("start_time");
    }

    public Long getDurationTs() {
        return this.probeData.getLong("duration_ts");
    }

    public Float getDuration() {
        return this.probeData.getFloat("duration");
    }

    public Integer getBitRate() {
        return this.probeData.getInteger("bit_rate");
    }

    public Integer getMaxBitRate() {
        return this.probeData.getInteger("max_bit_rate");
    }

    public Integer getBitsPerRawSample() {
        return this.probeData.getInteger("bits_per_raw_sample");
    }

    public Integer getNbFrames() {
        return this.probeData.getInteger("nb_frames");
    }

    public Integer getNbReadFrames() {
        return this.probeData.getInteger("nb_read_frames");
    }

    public Integer getNbReadPackets() {
        return this.probeData.getInteger("nb_read_packets");
    }
}

